/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;

public class Settings {
    public static boolean ShowDebug() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Debug.Show", false);
    }

    public static String ScriptQueueSpeed() {
        String delay = DenizenAPI.getCurrentInstance().getConfig().getString("Scripts.Queue Speed", "0.5s");
        try {
            if (Double.valueOf(delay) < 1.0) {
                delay = "1t";
            }
        }
        catch (Exception e) {
            delay = "0.5s";
        }
        return delay;
    }

    public static boolean LoadScriptsInSubfolders() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Scripts.Load Scripts in Subfolders", true);
    }

    public static boolean HealthTraitEnabledByDefault() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Enabled", false);
    }

    public static boolean HealthTraitRespawnEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Respawn.Enabled", true);
    }

    public static boolean HealthTraitAnimatedDeathEnabled() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Traits.Health.Animated Death.Enabled", true);
    }

    public static String HealthTraitRespawnDelay() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Traits.Health.Respawn.Delay", "10s");
    }

    public static boolean TriggerEnabled(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Enabled", true);
    }

    public static double TriggerDefaultCooldown(String triggerName) {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Cooldown", "5s")).getSeconds();
    }

    public static double TriggerDefaultRange(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Range", -1.0);
    }

    public static String TriggerDefaultCooldownType(String triggerName) {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + triggerName.substring(1).toLowerCase() + ".Cooldown Type", "Player");
    }

    public static boolean ClickTriggerAllowsLeftClick() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Click.Allows Left Click", false);
    }

    public static String EngageTimeoutInSeconds() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Commands.Engage.Timeout", "150s");
    }

    public static String ChatToNpcFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to NPC", "You -> <npc.name.nickname>: <text>");
    }

    public static String ChatToNpcOverheardFormat() {
        return DenizenAPI.getCurrentInstance().getConfig().getString("Triggers.Chat.Formats.Player to Bystanders", "<player.name> -> <npc.name.nickname>: <text>");
    }

    public static double ChatToNpcOverhearingRange() {
        return DenizenAPI.getCurrentInstance().getConfig().getDouble("Triggers.Chat.Overhearing Range", 4.0);
    }

    public static boolean ChatMustSeeNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must Be Able to See NPC", true);
    }

    public static boolean ChatMustLookAtNPC() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Prerequisites.Must Be Looking in Direction of NPC", true);
    }

    public static boolean ChatGloballyIfFailedChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If Triggers Failed", false);
    }

    public static boolean ChatGloballyIfNoChatTriggers() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If Triggers Missing", true);
    }

    public static boolean ChatGloballyIfUninteractable() {
        return DenizenAPI.getCurrentInstance().getConfig().getBoolean("Triggers.Chat.Appears Globally.If NPC Uninteractable", true);
    }

    public static Duration WorldScriptTimeEventResolution() {
        return Duration.valueOf(DenizenAPI.getCurrentInstance().getConfig().getString("Events.On time resolution", "250t"));
    }
}

