/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;

public class EquipCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dItem hand = null;
        dItem head = null;
        dItem chest = null;
        dItem legs = null;
        dItem boots = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("ITEMINHAND, HAND, HOLDING", arg, aH.ArgumentType.String)) {
                arg = "ITEM:" + arg.split(":")[1];
                if (!aH.matchesItem(arg)) continue;
                hand = aH.getItemFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("HEAD, HELMET", arg, aH.ArgumentType.String)) {
                arg = "ITEM:" + arg.split(":")[1];
                if (!aH.matchesItem(arg)) continue;
                head = aH.getItemFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("CHEST, CHESTPLATE", arg, aH.ArgumentType.String)) {
                arg = "ITEM:" + arg.split(":")[1];
                if (!aH.matchesItem(arg)) continue;
                chest = aH.getItemFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("LEGS, LEGGINGS", arg, aH.ArgumentType.String)) {
                arg = "ITEM:" + arg.split(":")[1];
                if (!aH.matchesItem(arg)) continue;
                legs = aH.getItemFrom(arg);
                continue;
            }
            if (!aH.matchesValueArg("BOOTS", arg, aH.ArgumentType.String) || !aH.matchesItem(arg = "ITEM:" + arg.split(":")[1])) continue;
            boots = aH.getItemFrom(arg);
        }
        scriptEntry.addObject("hand", hand).addObject("head", head).addObject("chest", chest).addObject("legs", legs).addObject("boots", boots);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dItem hand = (dItem)scriptEntry.getObject("hand");
        dItem head = (dItem)scriptEntry.getObject("head");
        dItem chest = (dItem)scriptEntry.getObject("chest");
        dItem legs = (dItem)scriptEntry.getObject("legs");
        dItem boots = (dItem)scriptEntry.getObject("boots");
        NPC npc = scriptEntry.getNPC().getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        Equipment trait = (Equipment)npc.getTrait(Equipment.class);
        if (hand != null) {
            trait.set(0, hand.getItemStack());
        }
        if (head != null) {
            trait.set(1, head.getItemStack());
        }
        if (chest != null) {
            trait.set(2, chest.getItemStack());
        }
        if (legs != null) {
            trait.set(3, legs.getItemStack());
        }
        if (boots != null) {
            trait.set(4, boots.getItemStack());
        }
    }
}

