/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class HealthCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        Integer qty = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesToggle(arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("SET_MAX", arg, aH.ArgumentType.Integer)) {
                if (action == null) {
                    action = Action.SET_MAX;
                }
                qty = aH.getIntegerFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (action == null || scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("Missing Action or NPC!");
        }
        scriptEntry.addObject("action", (Object)action).addObject("qty", qty);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Integer qty = (Integer)scriptEntry.getObject("qty");
        dB.report(this.getName(), aH.debugObj("Action", action.name()) + (qty != null ? aH.debugObj("health", qty.toString()) : ""));
        switch (action) {
            case TRUE: {
                scriptEntry.getNPC().getCitizen().addTrait(HealthTrait.class);
                break;
            }
            case FALSE: {
                scriptEntry.getNPC().getCitizen().removeTrait(HealthTrait.class);
                break;
            }
            case TOGGLE: {
                if (scriptEntry.getNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    scriptEntry.getNPC().getCitizen().removeTrait(HealthTrait.class);
                    break;
                }
                scriptEntry.getNPC().getCitizen().addTrait(HealthTrait.class);
            }
        }
        if (scriptEntry.getNPC().getCitizen().hasTrait(HealthTrait.class) && qty != null) {
            scriptEntry.getNPC().getHealthTrait().setMaxhealth(qty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        TRUE,
        FALSE,
        TOGGLE,
        SET_MAX;

    }
}

