/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrigger
implements RegistrationableInstance {
    public Denizen denizen;
    protected String name;

    @Override
    public AbstractTrigger activate() {
        this.denizen = (Denizen)Bukkit.getPluginManager().getPlugin("Denizen");
        return this;
    }

    @Override
    public AbstractTrigger as(String triggerName) {
        this.name = triggerName.toUpperCase();
        this.denizen.getTriggerRegistry().register(triggerName, this);
        this.onEnable();
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onDisable() {
    }

    public boolean parse(dNPC npc, Player player, InteractScriptContainer script) {
        return this.parse(npc, player, script, null);
    }

    public boolean parse(dNPC npc, Player player, InteractScriptContainer script, String id) {
        if (npc == null || player == null || script == null) {
            return false;
        }
        List<ScriptEntry> entries = script.getEntriesFor(this, player, npc, id);
        if (entries.isEmpty()) {
            return false;
        }
        dB.echoDebug(dB.DebugElement.Header, "Parsing " + this.name + " trigger: " + npc.getName() + "/" + player.getName());
        ScriptQueue._getQueue(ScriptQueue._getNextId()).addEntries(entries).start();
        return true;
    }

    public Set<NPC> getActiveNPCsWithinRangeWithTrigger(Location location, int maxRange) {
        HashSet<NPC> closestNPCs = new HashSet<NPC>();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getBukkitEntity().getLocation().distance(location) < (double)maxRange) || !npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }
}

