/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.text.DecimalFormat;
import java.util.Arrays;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.arguments.ObjectFetcher;
import net.aufdemrand.denizen.utilities.arguments.dList;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class Element
implements dScriptArgument {
    private String prefix;
    private String element;

    @ObjectFetcher(value="l")
    public static Element valueOf(String string) {
        if (string == null) {
            return null;
        }
        String prefix = null;
        if (string.split(":").length > 1) {
            prefix = string.split(":", 2)[0];
            string = string.split(":", 2)[1];
        }
        return new Element(prefix, string);
    }

    public Element(String string) {
        this.prefix = "element";
        this.element = string;
    }

    public Element(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = string;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.element + "<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.element;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("asint") || attribute.startsWith("as_int")) {
            try {
                return new Element(String.valueOf(Integer.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Integer.");
                return null;
            }
        }
        if (attribute.startsWith("asdouble") || attribute.startsWith("as_double")) {
            try {
                return new Element(String.valueOf(Double.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Double.");
                return null;
            }
        }
        if (attribute.startsWith("asmoney") || attribute.startsWith("as_money")) {
            try {
                DecimalFormat d = new DecimalFormat("0.00");
                return new Element(String.valueOf(d.format(Double.valueOf(this.element)))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Money format.");
                return null;
            }
        }
        if (attribute.startsWith("asboolean") || attribute.startsWith("as_boolean")) {
            return new Element(Boolean.valueOf(this.element).toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("aslist") || attribute.startsWith("as_list")) {
            return new dList("List", this.element).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("substring")) {
            int beginning_index = Integer.valueOf(attribute.getContext(1).split(",")[0]) - 1;
            int ending_index = Integer.valueOf(attribute.getContext(1).split(",")[1]) - 1;
            return new Element(String.valueOf(this.element.substring(beginning_index, ending_index))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_color")) {
            return new Element(String.valueOf(ChatColor.getLastColors((String)this.element))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("split") && attribute.startsWith("limit", 2)) {
            String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            Integer limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
            if (split_string.toUpperCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1], limit))).getAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(StringUtils.split((String)this.element, (String)split_string, (int)limit))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("split")) {
            String split_string;
            String string = split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            if (split_string.toUpperCase().startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1]))).getAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(StringUtils.split((String)this.element, (String)split_string))).getAttribute(attribute.fulfill(1));
        }
        return this.element;
    }
}

