/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.ObjectFetcher;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.arguments.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_5_R3.Entity;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_5_R3.CraftWorld;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class dEntity
implements dScriptArgument {
    public static Map<String, dEntity> entities = new HashMap<String, dEntity>();
    private String id = null;
    private String prefix = "Entity";
    private LivingEntity entity = null;

    public static dEntity getSavedEntity(String id) {
        if (entities.containsKey(id.toUpperCase())) {
            return entities.get(id.toUpperCase());
        }
        return null;
    }

    public static void saveEntity(dEntity entity) {
        if (entity.id == null) {
            return;
        }
        entities.put(entity.id.toUpperCase(), entity);
    }

    public static boolean isSavedEntity(String id) {
        return entities.containsKey(id.toUpperCase());
    }

    public static void _recallEntities() {
        List entitylist = DenizenAPI.getCurrentInstance().getSaves().getMapList("dScript.Entities");
        entities.clear();
    }

    public static void _saveEntities() {
    }

    @ObjectFetcher(value="e")
    public static dEntity valueOf(String string) {
        Pattern matchesEntityPtrn = Pattern.compile("(?:.+?:|)((p@|n@|e@|player\\.|npc\\.|entity\\.)(.+))", 2);
        Matcher m = matchesEntityPtrn.matcher(string);
        if (m.matches()) {
            String entityGroup = m.group(1);
            String entityGroupUpper = entityGroup.toUpperCase();
            if (entityGroupUpper.startsWith("N@") || entityGroupUpper.startsWith("NPC.")) {
                LivingEntity returnable;
                NPC npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(m.group(3)).intValue());
                if (!npc.isSpawned()) {
                    npc.spawn(npc.getStoredLocation());
                }
                if ((returnable = npc.getBukkitEntity()) != null) {
                    return new dEntity(returnable);
                }
                dB.echoError("Invalid NPC! '" + entityGroup + "' could not be found. Has it been despawned or killed?");
            } else if (entityGroupUpper.startsWith("P@") || entityGroupUpper.startsWith("PLAYER.")) {
                Player returnable = aH.getPlayerFrom(m.group(3));
                if (returnable != null) {
                    return new dEntity((LivingEntity)returnable);
                }
                dB.echoError("Invalid Player! '" + entityGroup + "' could not be found. Has the player logged off?");
            } else {
                if (aH.matchesInteger(m.group(3))) {
                    World world;
                    int entityID = Integer.valueOf(m.group(3));
                    Entity entity = null;
                    Iterator i$ = Bukkit.getWorlds().iterator();
                    while (i$.hasNext() && (entity = ((CraftWorld)(world = (World)i$.next())).getHandle().getEntity(entityID)) == null) {
                    }
                    if (entity != null) {
                        return new dEntity((LivingEntity)entity.getBukkitEntity());
                    }
                }
                dB.echoError("Invalid entity! '" + entityGroup + "' could not be found. Has it been despawned or killed?");
            }
        }
        return null;
    }

    public dEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public dEntity(String id, LivingEntity entity) {
        this.entity = entity;
        this.id = id;
        dEntity.saveEntity(this);
    }

    public void identifyAs(String id) {
        if (this.id == null) {
            this.id = id;
            dEntity.saveEntity(this);
        }
    }

    public LivingEntity getBukkitEntity() {
        return this.entity;
    }

    public boolean isAlive() {
        return this.entity != null;
    }

    public dEntity setId(String id) {
        this.id = id.toUpperCase();
        return this;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return null;
    }

    public String as_dScriptArg() {
        return null;
    }

    public String dScriptArgValue() {
        return this.getDefaultPrefix().toLowerCase() + ":" + this.as_dScriptArg();
    }

    public String toString() {
        return this.entity.getUniqueId().toString();
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public LivingEntity getEntity(String string) {
        return this.entity;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (this.entity == null) {
            dB.echoDebug("dEntity has returned null.");
            return "null";
        }
        if (attribute.startsWith("name")) {
            return new Element(this.entity.getCustomName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            return new dLocation(this.entity.getTargetBlock(null, range).getLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location.standing_on")) {
            return new dLocation(this.entity.getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.entity.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.formatted")) {
            int maxHealth = this.entity.getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.1) {
                return new Element("dying").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.4) {
                return new Element("seriously wounded").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.75) {
                return new Element("injured").getAttribute(attribute.fulfill(2));
            }
            if ((float)this.entity.getHealth() / (float)maxHealth < 1.0f) {
                return new Element("scraped").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            int maxHealth = this.entity.getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(String.valueOf((float)this.entity.getHealth() / (float)maxHealth * 100.0f)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new Element(String.valueOf(this.entity.getHealth())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_inside_vehicle")) {
            return new Element(String.valueOf(this.entity.isInsideVehicle())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return new dPlayer((OfflinePlayer)this.entity.getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage_cause")) {
            return new Element(String.valueOf(this.entity.getLastDamageCause().getCause().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage")) {
            return new Element(String.valueOf(this.entity.getLastDamage())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.entity.getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items")) {
            return new Element(String.valueOf(this.entity.getCanPickupItems())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_id")) {
            return new Element(String.valueOf(this.entity.getEntityId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(String.valueOf(this.entity.getFallDistance())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(String.valueOf(this.entity.getUniqueId().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            // empty if block
        }
        if (attribute.startsWith("equipment")) {
            // empty if block
        }
        if (attribute.startsWith("world")) {
            // empty if block
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return this.dScriptArgValue();
    }
}

