/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dEntity;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class MountCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Object> entities = new ArrayList<Object>();
        Boolean dismount = false;
        dLocation location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("cancel", arg)) {
                dismount = true;
                dB.echoDebug("...will dismount.");
                continue;
            }
            if (aH.matchesValueArg("TARGETS, TARGET", arg, aH.ArgumentType.Custom)) {
                LivingEntity entity = null;
                for (String target : aH.getListFrom(arg)) {
                    if (aH.matchesEntityType(target)) {
                        dLocation entityLocation = null;
                        if (location != null) {
                            entityLocation = location;
                        } else if (scriptEntry.getPlayer() != null) {
                            entityLocation = new dLocation(scriptEntry.getPlayer().getLocation());
                        } else if (scriptEntry.getNPC() != null) {
                            entityLocation = new dLocation(scriptEntry.getNPC().getLocation());
                        }
                        if (entityLocation != null) {
                            EntityType entityType = aH.getEntityFrom(target);
                            entity = entityLocation.getWorld().spawnEntity((Location)entityLocation, entityType);
                        }
                    } else {
                        entity = dEntity.valueOf(target).getBukkitEntity();
                    }
                    if (entity != null) {
                        entities.add(entity);
                        continue;
                    }
                    dB.echoError("Invalid target '%s'!", target);
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entities.size() == 0) {
            entities.add(scriptEntry.getPlayer());
            entities.add(scriptEntry.getNPC().getEntity());
        }
        if (entities.size() == 1) {
            entities.add(0, scriptEntry.getPlayer());
        }
        scriptEntry.addObject("entities", entities);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("dismount", dismount);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Boolean dismount = (Boolean)scriptEntry.getObject("dismount");
        dB.echoApproval("<G>Executing '<Y>" + this.getName() + "<G>': " + "Targets=<Y>'" + entities.toString() + "<G>'");
        Entity lastEntity = null;
        for (Entity entity : entities) {
            if (dismount.booleanValue()) {
                entity.leaveVehicle();
                continue;
            }
            if (lastEntity != null && entity.getPassenger() != lastEntity) {
                lastEntity.teleport(entity.getLocation());
                entity.setPassenger(lastEntity);
            }
            lastEntity = entity;
        }
        if (location != null) {
            lastEntity.teleport((Location)location);
        }
    }
}

