/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.DenizenRegistry;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.EnchantedRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.FlaggedRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.HoldingRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.InGroupRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.ItemRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.LiquidRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.MoneyRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.OpRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.OwnerRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.OxygenRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.PermissionRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.PoweredRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.ProcedureRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.ScriptRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.SneakingRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.StormRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.SunnyRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.TimeRequirement;
import net.aufdemrand.denizen.scripts.requirements.core.WorldGuardRegionRequirement;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementRegistry
implements DenizenRegistry {
    public Denizen denizen;
    private Map<String, AbstractRequirement> instances = new HashMap<String, AbstractRequirement>();
    private Map<Class<? extends AbstractRequirement>, String> classes = new HashMap<Class<? extends AbstractRequirement>, String>();

    public RequirementRegistry(Denizen denizen) {
        this.denizen = denizen;
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractRequirement member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public AbstractRequirement get(String requirementName) {
        if (this.instances.containsKey(requirementName.toUpperCase())) {
            return this.instances.get(requirementName.toUpperCase());
        }
        return null;
    }

    public Map<String, AbstractRequirement> list() {
        return this.instances;
    }

    @Override
    public boolean register(String requirementName, RegistrationableInstance requirementClass) {
        this.instances.put(requirementName.toUpperCase(), (AbstractRequirement)requirementClass);
        this.classes.put(((AbstractRequirement)requirementClass).getClass(), requirementName.toUpperCase());
        return true;
    }

    @Override
    public void registerCoreMembers() {
        this.registerCoreMember(EnchantedRequirement.class, "ENCHANTED", "enchanted (iteminhand)", 1);
        this.registerCoreMember(FlaggedRequirement.class, "FLAGGED", "(-)flagged [player|npc|global] [name([#])](:value)", 0);
        this.registerCoreMember(HoldingRequirement.class, "HOLDING", "holding [item] [qty:#] [exact]", 1);
        this.registerCoreMember(InGroupRequirement.class, "INGROUP", "ingroup (global) [group]", 1);
        this.registerCoreMember(ItemRequirement.class, "ITEM", "item [item] (qty:#)", 1);
        this.registerCoreMember(LiquidRequirement.class, "ISLIQUID", "isliquid [location:x,y,z,world]", 1);
        this.registerCoreMember(MoneyRequirement.class, "MONEY", "money [qty:#]", 1);
        this.registerCoreMember(OpRequirement.class, "OP", "op (no args)", 0);
        this.registerCoreMember(OwnerRequirement.class, "OWNER", "owner (no args)", 0);
        this.registerCoreMember(PermissionRequirement.class, "PERMISSION", "permission (global) [permission]", 1);
        this.registerCoreMember(PoweredRequirement.class, "ISPOWERED", "ispowered [location:x,y,z,world]", 1);
        this.registerCoreMember(OxygenRequirement.class, "OXYGEN", "oxygen (range:below|equals|above) [qty:#]", 1);
        this.registerCoreMember(ProcedureRequirement.class, "PROCEDURE", "procedure [script:procedure_script]", 1);
        this.registerCoreMember(ScriptRequirement.class, "SCRIPT", "script [finished|failed] [script:name]", 0);
        this.registerCoreMember(SneakingRequirement.class, "SNEAKING", "sneaking (no args)", 0);
        this.registerCoreMember(StormRequirement.class, "STORMING", "storm (no args)", 0);
        this.registerCoreMember(SunnyRequirement.class, "SUNNY", "sunny (no args)", 0);
        this.registerCoreMember(TimeRequirement.class, "TIME", "time [dawn, day, dush, night]", 1);
        this.registerCoreMember(WorldGuardRegionRequirement.class, "INREGION", "inregion [name:regionname]", 1);
        dB.echoApproval("Loaded core requirements: " + this.instances.keySet().toString());
    }

    private <T extends AbstractRequirement> void registerCoreMember(Class<T> requirement, String name, String hint, int args) {
        block2: {
            try {
                ((AbstractRequirement)requirement.newInstance()).activate().as(name).withOptions("(-)" + hint, args);
            }
            catch (Exception e) {
                dB.echoError("Could not register requirement " + name + ": " + e.getMessage());
                if (!dB.showStackTraces) break block2;
                e.printStackTrace();
            }
        }
    }
}

