/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities.core;

import net.aufdemrand.denizen.npc.activities.core.TaskActivity;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;

public class TaskGoal
implements Goal {
    private dNPC npc;
    private TaskActivity activity;
    private final int delay;
    private final int duration;
    private final int repeats;
    private final String scriptName;
    private int counter = 0;
    private long dur = 0L;
    private long cooldown = 0L;

    public TaskGoal(dNPC npc, int delay, int duration, String scriptName, int repeats, TaskActivity activityInstance) {
        this.activity = activityInstance;
        this.npc = npc;
        this.delay = delay;
        this.duration = duration;
        this.repeats = repeats;
        this.scriptName = scriptName;
    }

    public void reset() {
    }

    public void run(GoalSelector goalSelecter) {
        if (this.dur > 0L) {
            if (this.dur < System.currentTimeMillis()) {
                ++this.counter;
                this.cooldown();
                this.dur = 0L;
                goalSelecter.finish();
            } else {
                this.dur = System.currentTimeMillis() + (long)(this.duration * 1000);
                TaskScriptContainer taskScript = ScriptRegistry.getScriptContainerAs(this.scriptName, TaskScriptContainer.class);
                taskScript.runTaskScript(null, this.npc, null);
            }
        }
    }

    public boolean shouldExecute(GoalSelector arg0) {
        if (this.counter <= this.repeats || this.repeats == -1) {
            return this.isCool();
        }
        return false;
    }

    public void cooldown() {
        this.cooldown = System.currentTimeMillis() + (long)(this.delay * 1000);
    }

    public boolean isCool() {
        return this.cooldown < System.currentTimeMillis();
    }
}

