/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnnounceCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        AnnounceType announceType = AnnounceType.ALL;
        FormatScriptContainer format = null;
        String flag = null;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("TO_OPS", arg)) {
                announceType = AnnounceType.TO_OPS;
                continue;
            }
            if (aH.matchesArg("FORMAT", arg)) {
                String formatStr = aH.getStringFrom(arg);
                format = ScriptRegistry.getScriptContainerAs(formatStr, FormatScriptContainer.class);
                if (format != null) continue;
                dB.echoError("Invalid format: " + formatStr);
                continue;
            }
            if (aH.matchesValueArg("TO_FLAGGED", arg, aH.ArgumentType.Custom)) {
                flag = aH.getStringFrom(arg);
                announceType = AnnounceType.TO_FLAGGED;
                continue;
            }
            text = aH.getStringFrom(arg);
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text).addObject("type", (Object)announceType).addObject("format", format).addObject("flag", flag);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        block3: {
            String message;
            String flag;
            AnnounceType type;
            block4: {
                block2: {
                    String text = (String)scriptEntry.getObject("text");
                    type = (AnnounceType)((Object)scriptEntry.getObject("type"));
                    FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
                    flag = (String)scriptEntry.getObject("flag");
                    dB.report(this.getName(), aH.debugObj("Message", text) + (format != null ? aH.debugObj("Format", format.getName()) : "") + aH.debugObj("Type", type.name()) + (flag != null ? aH.debugObj("Flag_Name", flag) : ""));
                    String string = message = format != null ? format.getFormattedText(scriptEntry) : text;
                    if (type != AnnounceType.ALL) break block2;
                    this.denizen.getServer().broadcastMessage(message);
                    break block3;
                }
                if (type != AnnounceType.TO_OPS) break block4;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.isOp()) continue;
                    player.sendMessage(message);
                }
                break block3;
            }
            if (type != AnnounceType.TO_FLAGGED) break block3;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!FlagManager.playerHasFlag(player, flag)) continue;
                player.sendMessage(message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AnnounceType {
        ALL,
        TO_OPS,
        TO_FLAGGED;

    }
}

