/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dEntity;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FlyCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Object> entities = new ArrayList<Object>();
        ArrayList<dLocation> destinations = new ArrayList<dLocation>();
        dLocation origin = null;
        Boolean dismount = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("origin", arg, aH.ArgumentType.Location)) {
                origin = aH.getLocationFrom(arg);
                dB.echoDebug("...origin set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("cancel", arg)) {
                dismount = true;
                dB.echoDebug("...will dismount.");
                continue;
            }
            if (aH.matchesValueArg("destination, destinations", arg, aH.ArgumentType.Custom)) {
                for (String destination : aH.getListFrom(arg)) {
                    if (!aH.matchesLocation("location:" + destination)) continue;
                    destinations.add(aH.getLocationFrom(destination));
                    dB.echoDebug("...added '%s' to destinations.", arg);
                }
                continue;
            }
            if (aH.matchesValueArg("entities, entity", arg, aH.ArgumentType.Custom)) {
                LivingEntity entity = null;
                for (String target : aH.getListFrom(arg)) {
                    if (aH.matchesEntityType(target)) {
                        dLocation entityLocation = null;
                        if (origin != null) {
                            entityLocation = origin;
                        } else if (scriptEntry.getPlayer() != null) {
                            entityLocation = new dLocation(scriptEntry.getPlayer().getLocation());
                        } else if (scriptEntry.getNPC() != null) {
                            entityLocation = new dLocation(scriptEntry.getNPC().getLocation());
                        }
                        if (entityLocation != null) {
                            EntityType entityType = aH.getEntityFrom(target);
                            entity = entityLocation.getWorld().spawnEntity((Location)entityLocation, entityType);
                        }
                    } else {
                        entity = dEntity.valueOf(target).getBukkitEntity();
                    }
                    if (entity != null) {
                        entities.add(entity);
                        continue;
                    }
                    dB.echoError("Invalid entity '%s'!", target);
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entities.size() == 0) {
            entities.add(scriptEntry.getPlayer());
            entities.add(scriptEntry.getNPC().getEntity());
        }
        if (entities.size() == 1) {
            entities.add(0, scriptEntry.getPlayer());
        }
        scriptEntry.addObject("entities", entities);
        scriptEntry.addObject("destinations", destinations);
        scriptEntry.addObject("origin", origin);
        scriptEntry.addObject("dismount", dismount);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation origin = (dLocation)scriptEntry.getObject("origin");
        List entities = (List)scriptEntry.getObject("entities");
        final List destinations = (List)scriptEntry.getObject("destinations");
        Boolean dismount = (Boolean)scriptEntry.getObject("dismount");
        Entity lastEntity = null;
        for (Entity entity : entities) {
            if (dismount.booleanValue()) {
                entity.leaveVehicle();
                continue;
            }
            if (lastEntity != null && entity.getPassenger() != lastEntity) {
                lastEntity.teleport(entity.getLocation());
                entity.setPassenger(lastEntity);
            }
            lastEntity = entity;
        }
        if (origin != null) {
            lastEntity.teleport((Location)origin);
        }
        if (dismount.booleanValue()) {
            return;
        }
        final Entity entity = lastEntity;
        final Player player = scriptEntry.getPlayer();
        final Boolean freeflight = destinations.size() <= 0;
        BukkitRunnable task = new BukkitRunnable(){
            Location location = null;
            Boolean flying = true;

            public void run() {
                if (freeflight.booleanValue()) {
                    this.location = player.getEyeLocation().add(player.getEyeLocation().getDirection().multiply(30));
                } else if (destinations.size() > 0) {
                    this.location = (Location)destinations.get(0);
                } else {
                    this.flying = false;
                }
                if (this.flying.booleanValue() && entity.isValid() && !entity.isEmpty()) {
                    if (!Utilities.isFacingLocation(entity, this.location, 50.0f)) {
                        Utilities.faceLocation(entity, this.location);
                    }
                    Vector v1 = entity.getLocation().toVector();
                    Vector v2 = this.location.toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(1.5);
                    entity.setVelocity(v3);
                    if (!freeflight.booleanValue() && Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        destinations.remove(0);
                    }
                } else {
                    this.flying = false;
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 3L);
    }
}

