/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dEntity;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.midi.MidiUtil;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MidiCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        File file = null;
        float tempo = 1.0f;
        dLocation location = null;
        HashSet<Player> listeners = new HashSet<Player>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("file, f", arg, aH.ArgumentType.Custom)) {
                try {
                    String path = "plugins/Denizen/midi/" + aH.getStringFrom(arg);
                    if (!path.endsWith(".mid")) {
                        path = path + ".mid";
                    }
                    file = new File(path);
                }
                catch (Exception e) {
                    dB.echoError("Invalid file!");
                }
                continue;
            }
            if (aH.matchesValueArg("listeners, l", arg, aH.ArgumentType.Custom)) {
                LivingEntity entity = null;
                for (String listener : aH.getListFrom(arg)) {
                    entity = dEntity.valueOf(listener).getBukkitEntity();
                    if (entity != null && entity instanceof Player) {
                        listeners.add((Player)entity);
                        continue;
                    }
                    dB.echoError("Invalid listener '%s'!", listener);
                }
                continue;
            }
            if (aH.matchesValueArg("tempo, t", arg, aH.ArgumentType.Float)) {
                tempo = aH.getFloatFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (file == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "FILE");
        }
        if (location == null && listeners.size() == 0) {
            listeners.add(scriptEntry.getPlayer());
        }
        scriptEntry.addObject("file", file);
        scriptEntry.addObject("listeners", listeners);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("tempo", Float.valueOf(tempo));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        File file = (File)scriptEntry.getObject("file");
        Set listeners = (Set)scriptEntry.getObject("listeners");
        Location location = (Location)scriptEntry.getObject("location");
        Float tempo = (Float)scriptEntry.getObject("tempo");
        dB.report(this.getName(), aH.debugObj("Playing midi file", file.getPath() + (listeners != null ? aH.debugObj("Listeners", listeners) : "") + (location != null ? aH.debugObj("Location", location) : "")) + aH.debugObj("Tempo", tempo));
        if (location != null) {
            MidiUtil.playMidiQuietly(file, tempo.floatValue(), location);
        } else {
            MidiUtil.playMidiQuietly(file, tempo.floatValue(), listeners);
        }
    }
}

