/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Effect;
import org.bukkit.Location;

public class PlayEffectCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Effect effect = null;
        int radius = 3;
        int data = 0;
        dLocation location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("effect, e", arg, aH.ArgumentType.Custom)) {
                try {
                    effect = Effect.valueOf((String)aH.getStringFrom(arg).toUpperCase());
                }
                catch (Exception e) {
                    dB.echoError("Invalid effect!");
                }
                continue;
            }
            if (aH.matchesValueArg("radius, r", arg, aH.ArgumentType.Integer)) {
                radius = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("data, d", arg, aH.ArgumentType.Integer)) {
                data = aH.getIntegerFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (effect == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "EFFECT");
        }
        if (location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("effect", effect);
        scriptEntry.addObject("radius", radius);
        scriptEntry.addObject("data", data);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        int radius = (Integer)scriptEntry.getObject("radius");
        int data = (Integer)scriptEntry.getObject("data");
        dB.echoApproval("Executing '" + this.getName() + "': " + "Location='" + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "', " + "Effect='" + effect.toString() + ", " + "Data='" + data + ", " + "Radius='" + radius + "'");
        location.getWorld().playEffect(location, effect, data, radius);
    }
}

