/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ShooterType shooterType = ShooterType.NPC;
        LivingEntity shooter = null;
        EntityType entityType = null;
        dLocation location = null;
        Script newScript = null;
        Boolean ride = false;
        Boolean burn = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesEntityType(arg)) {
                entityType = aH.getEntityFrom(arg);
                dB.echoDebug("...projectile set to '%s'.", arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("PLAYER", arg)) {
                shooterType = ShooterType.PLAYER;
                dB.echoDebug("... will be shot by the player!");
                continue;
            }
            if (aH.matchesScript(arg)) {
                newScript = aH.getScriptFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, arg);
                continue;
            }
            if (aH.matchesArg("ride, mount", arg)) {
                ride = true;
                dB.echoDebug("...will be mounted.");
                continue;
            }
            if (aH.matchesArg("burn, burning", arg)) {
                burn = true;
                dB.echoDebug("...will burn.");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (shooterType.name().equals("NPC")) {
            shooter = scriptEntry.getNPC().getEntity();
        } else if (shooterType.name().equals("PLAYER")) {
            shooter = scriptEntry.getPlayer();
        }
        if (location == null) {
            location = shooter.getEyeLocation().add(shooter.getEyeLocation().getDirection().multiply(40));
        }
        if (entityType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ENTITY);
        }
        scriptEntry.addObject("entityType", entityType);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("shooter", shooter);
        scriptEntry.addObject("shooterType", (Object)shooterType);
        scriptEntry.addObject("script", newScript);
        scriptEntry.addObject("ride", ride);
        scriptEntry.addObject("burn", burn);
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        final Location location = (Location)scriptEntry.getObject("location");
        LivingEntity shooter = (LivingEntity)scriptEntry.getObject("shooter");
        ShooterType shooterType = (ShooterType)((Object)scriptEntry.getObject("shooterType"));
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        Boolean ride = (Boolean)scriptEntry.getObject("ride");
        Boolean burn = (Boolean)scriptEntry.getObject("burn");
        if (shooterType.name().equals("NPC") || !Utilities.isFacingLocation((Entity)shooter, location, 45.0f)) {
            Utilities.faceLocation((Entity)shooter, location);
        }
        final Entity entity = shooter.getWorld().spawnEntity(shooter.getEyeLocation().add(shooter.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0), entityType);
        Utilities.faceLocation(entity, location);
        if (ride.booleanValue()) {
            entity.setPassenger((Entity)scriptEntry.getPlayer());
        }
        if (burn.booleanValue()) {
            entity.setFireTicks(500);
        }
        if (entity instanceof Projectile) {
            ((Projectile)entity).setShooter(shooter);
        }
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (this.runs < 40 && entity.isValid()) {
                    Vector v1 = entity.getLocation().toVector();
                    Vector v2 = location.toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(1.5);
                    entity.setVelocity(v3);
                    ++this.runs;
                    if (Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        this.runs = 40;
                    }
                    if (!entity.getLocation().add(v3).getBlock().getType().toString().equals("AIR")) {
                        this.runs = 40;
                    }
                } else {
                    this.cancel();
                    this.runs = 0;
                    if (scriptEntry.getObject("script") != null) {
                        HashMap<String, String> context = new HashMap<String, String>();
                        context.put("1", entity.getLocation().getX() + "," + entity.getLocation().getY() + "," + entity.getLocation().getZ() + "," + entity.getLocation().getWorld().getName());
                        ((TaskScriptContainer)((Script)scriptEntry.getObject("script")).getContainer()).setSpeed(new Duration(0)).runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
                    }
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShooterType {
        NPC,
        PLAYER;

    }
}

