/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class HealthTrait
extends Trait
implements Listener {
    @Persist(value="animatedeath")
    private boolean animatedeath = Settings.HealthTraitAnimatedDeathEnabled();
    @Persist(value="animatedeathdelayinseconds")
    private String animationDelay = "3s";
    @Persist(value="respawnondeath")
    private boolean respawn = Settings.HealthTraitRespawnEnabled();
    @Persist(value="respawndelayinseconds")
    private String respawnDelay = Settings.HealthTraitRespawnDelay();
    @Persist(value="respawnlocation")
    private String respawnLocation = "<npc.location>";
    private Player player = null;
    private boolean dying = false;
    private Location loc;
    private int entityId = -1;

    public double getAnimationDelay() {
        return Duration.valueOf(this.animationDelay).getSeconds();
    }

    public double getRespawnDelay() {
        return Duration.valueOf(this.respawnDelay).getSeconds();
    }

    public void setRespawnLocation(String string) {
        if (aH.matchesLocation("location:" + string)) {
            this.respawnLocation = string;
        }
    }

    public void setRespawnDelay(int seconds) {
        this.respawnDelay = String.valueOf(seconds);
    }

    public void setRespawnDelay(String string) {
        if (aH.matchesDuration("duration:" + string)) {
            this.respawnDelay = string;
        }
    }

    public String getRespawnLocationAsString() {
        return this.respawnLocation;
    }

    public Location getRespawnLocation() {
        return aH.getLocationFrom(this.respawnLocation);
    }

    public void setDeathAnimationDelay(int seconds) {
        this.animationDelay = String.valueOf(seconds);
    }

    public void setDeathAnimationDelay(String string) {
        if (aH.matchesDuration("duration:" + string)) {
            this.animationDelay = string;
        }
    }

    public void setRespawnable(boolean respawnable) {
        this.respawn = respawnable;
    }

    public boolean isRespawnable() {
        return this.respawn;
    }

    public void animateOnDeath(boolean animate) {
        this.animatedeath = animate;
    }

    public boolean animatesOnDeath() {
        return this.animatedeath;
    }

    public void onSpawn() {
        this.dying = false;
        this.setHealth();
    }

    public HealthTrait() {
        super("health");
    }

    public int getHealth() {
        if (!this.npc.isSpawned()) {
            return 0;
        }
        return this.npc.getBukkitEntity().getHealth();
    }

    public void setMaxhealth(int newMax) {
        this.npc.getBukkitEntity().setMaxHealth(newMax);
    }

    public int getMaxhealth() {
        return this.npc.getBukkitEntity().getMaxHealth();
    }

    public void heal(int health) {
        this.setHealth(this.getHealth() + health);
    }

    public void setHealth() {
        this.setHealth(this.npc.getBukkitEntity().getMaxHealth());
    }

    public void setHealth(int health) {
        if (this.npc.getBukkitEntity() != null) {
            this.npc.getBukkitEntity().setHealth(health);
        }
    }

    public void die() {
        this.npc.getBukkitEntity().damage(this.npc.getBukkitEntity().getHealth());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity().getEntityId() != this.entityId) {
            return;
        }
        event.getDrops().clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() != this.npc.getBukkitEntity() || this.dying) {
            return;
        }
        if (this.getHealth() - event.getDamage() > 0) {
            return;
        }
        this.dying = true;
        this.player = null;
        this.entityId = this.npc.getBukkitEntity().getEntityId();
        String deathCause = event.getCause().toString().toLowerCase().replace('_', ' ');
        if (event instanceof EntityDamageByEntityEvent) {
            Entity killerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            if (killerEntity instanceof Player) {
                this.player = (Player)killerEntity;
            } else if (killerEntity instanceof Projectile) {
                LivingEntity shooter = ((Projectile)killerEntity).getShooter();
                if (shooter instanceof Player) {
                    this.player = (Player)shooter;
                }
                DenizenAPI.getDenizenNPC(this.npc).action("death by " + shooter.getType().toString(), this.player);
            }
            DenizenAPI.getDenizenNPC(this.npc).action("death by entity", this.player);
            DenizenAPI.getDenizenNPC(this.npc).action("death by " + killerEntity.getType().toString(), this.player);
        } else if (event instanceof EntityDamageByBlockEvent) {
            DenizenAPI.getDenizenNPC(this.npc).action("death by block", this.player);
        }
        DenizenAPI.getDenizenNPC(this.npc).action("death", this.player);
        DenizenAPI.getDenizenNPC(this.npc).action("death by " + deathCause, this.player);
        if (this.npc.getBukkitEntity() == null) {
            return;
        }
        this.loc = aH.getLocationFrom(TagManager.tag(null, DenizenAPI.getDenizenNPC(this.npc), this.respawnLocation, false));
        if (this.loc == null) {
            this.loc = this.npc.getBukkitEntity().getLocation();
        }
        if (this.animatedeath) {
            this.npc.getNavigator().cancelNavigation();
            this.setHealth();
            this.npc.getBukkitEntity().playEffect(EntityEffect.DEATH);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    HealthTrait.this.die();
                }
            }, 60L);
        } else {
            this.die();
        }
        if (this.respawn) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    if (HealthTrait.this.npc.isSpawned()) {
                        return;
                    }
                    HealthTrait.this.npc.spawn(HealthTrait.this.loc);
                }
            }, Duration.valueOf(this.respawnDelay).getTicks());
        }
    }
}

