/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.entity.Player;

public class EquipCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TargetType targetType = TargetType.NPC;
        HashMap<String, dItem> equipment = new HashMap<String, dItem>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("ITEMINHAND, HAND, HOLDING", arg, aH.ArgumentType.String)) {
                equipment.put("hand", this.getItem(arg));
                continue;
            }
            if (aH.matchesValueArg("HEAD, HELMET", arg, aH.ArgumentType.String)) {
                equipment.put("head", this.getItem(arg));
                continue;
            }
            if (aH.matchesValueArg("CHEST, CHESTPLATE", arg, aH.ArgumentType.String)) {
                equipment.put("chest", this.getItem(arg));
                continue;
            }
            if (aH.matchesValueArg("LEGS, LEGGINGS", arg, aH.ArgumentType.String)) {
                equipment.put("legs", this.getItem(arg));
                continue;
            }
            if (aH.matchesValueArg("BOOTS, FEET", arg, aH.ArgumentType.String)) {
                equipment.put("boots", this.getItem(arg));
                continue;
            }
            if (!aH.matchesArg("PLAYER", arg)) continue;
            targetType = TargetType.PLAYER;
            dB.echoDebug("... will be equipped by the player!");
        }
        scriptEntry.addObject("equipment", equipment);
        scriptEntry.addObject("targetType", (Object)targetType);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Map equipment = (Map)scriptEntry.getObject("equipment");
        TargetType targetType = (TargetType)((Object)scriptEntry.getObject("targetType"));
        if (targetType.toString().equals("NPC")) {
            NPC npc = scriptEntry.getNPC().getCitizen();
            if (npc != null) {
                if (!npc.hasTrait(Equipment.class)) {
                    npc.addTrait(Equipment.class);
                }
                Equipment trait = (Equipment)npc.getTrait(Equipment.class);
                if (equipment.get("hand") != null) {
                    trait.set(0, ((dItem)equipment.get("hand")).getItemStack());
                }
                if (equipment.get("head") != null) {
                    trait.set(1, ((dItem)equipment.get("head")).getItemStack());
                }
                if (equipment.get("chest") != null) {
                    trait.set(2, ((dItem)equipment.get("chest")).getItemStack());
                }
                if (equipment.get("legs") != null) {
                    trait.set(3, ((dItem)equipment.get("legs")).getItemStack());
                }
                if (equipment.get("boots") != null) {
                    trait.set(4, ((dItem)equipment.get("boots")).getItemStack());
                }
            }
        } else {
            Player player = scriptEntry.getPlayer();
            if (player != null) {
                if (equipment.get("hand") != null) {
                    player.getInventory().setItemInHand(((dItem)equipment.get("hand")).getItemStack());
                }
                if (equipment.get("head") != null) {
                    player.getInventory().setHelmet(((dItem)equipment.get("head")).getItemStack());
                }
                if (equipment.get("chest") != null) {
                    player.getInventory().setChestplate(((dItem)equipment.get("chest")).getItemStack());
                }
                if (equipment.get("legs") != null) {
                    player.getInventory().setLeggings(((dItem)equipment.get("legs")).getItemStack());
                }
                if (equipment.get("boots") != null) {
                    player.getInventory().setBoots(((dItem)equipment.get("boots")).getItemStack());
                }
            }
        }
    }

    public dItem getItem(String arg) {
        arg = "ITEM:" + aH.getStringFrom(arg);
        if (aH.matchesItem(arg)) {
            return aH.getItemFrom(arg);
        }
        dB.echoApproval("Invalid item " + arg + "!");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

