/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ExplodeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dLocation location = null;
        Float power = Float.valueOf(1.0f);
        boolean breakblocks = false;
        boolean fire = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesValueArg("power", arg, aH.ArgumentType.Float)) {
                power = Float.valueOf(aH.getFloatFrom(arg));
                dB.echoDebug("...will have a power of " + power);
                continue;
            }
            if (aH.matchesArg("breakblocks", arg)) {
                breakblocks = true;
                dB.echoDebug("...will break blocks.");
                continue;
            }
            if (aH.matchesArg("fire", arg)) {
                fire = true;
                dB.echoDebug("...will set fire on blocks.");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("power", power);
        scriptEntry.addObject("breakblocks", breakblocks);
        scriptEntry.addObject("fire", fire);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : scriptEntry.getNPC().getLocation();
        Float power = (Float)scriptEntry.getObject("power");
        boolean breakblocks = (Boolean)scriptEntry.getObject("breakblocks");
        boolean fire = (Boolean)scriptEntry.getObject("fire");
        location.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), power.floatValue(), fire, breakblocks);
    }
}

