/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        GiveType type = null;
        double amt = 1.0;
        dItem item = null;
        boolean engrave = false;
        for (String thisArg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("QTY", thisArg, aH.ArgumentType.Double)) {
                amt = aH.getDoubleFrom(thisArg);
                continue;
            }
            if (aH.matchesArg("MONEY", thisArg)) {
                type = GiveType.MONEY;
                continue;
            }
            if (aH.matchesArg("XP", thisArg) || aH.matchesArg("EXP", thisArg)) {
                type = GiveType.EXP;
                continue;
            }
            if (aH.matchesArg("ENGRAVE", thisArg)) {
                engrave = true;
                continue;
            }
            if (aH.matchesItem(thisArg) || aH.matchesItem("item:" + thisArg)) {
                item = aH.getItemFrom(thisArg);
                type = GiveType.ITEM;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, thisArg);
        }
        if (type == null) {
            throw new InvalidArgumentsException("Must specify a type! Valid: MONEY, XP, or ITEM:...");
        }
        if (type == GiveType.ITEM && item == null) {
            throw new InvalidArgumentsException("Item was returned as null.");
        }
        scriptEntry.addObject("type", (Object)type).addObject("amt", amt).addObject("item", item).addObject("engrave", engrave);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        GiveType type = (GiveType)((Object)scriptEntry.getObject("type"));
        Double amt = (Double)scriptEntry.getObject("amt");
        dItem item = (dItem)scriptEntry.getObject("item");
        Boolean engrave = (Boolean)scriptEntry.getObject("engrave");
        dB.report(this.getName(), aH.debugObj("Type", type.name()) + aH.debugObj("Amount", amt.toString()) + (item != null ? item.debug() : "") + (engrave != false ? aH.debugObj("Engraved", "TRUE") : ""));
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(scriptEntry.getPlayer().getName(), amt.doubleValue());
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case EXP: {
                scriptEntry.getPlayer().giveExp(amt.intValue());
                break;
            }
            case ITEM: {
                HashMap leftovers;
                ItemStack is = item.getItemStack();
                is.setAmount(amt.intValue());
                if (engrave.booleanValue()) {
                    is = NBTItem.addCustomNBT(item.getItemStack(), "owner", scriptEntry.getPlayer().getName());
                }
                if ((leftovers = scriptEntry.getPlayer().getInventory().addItem(new ItemStack[]{is})).isEmpty()) break;
                dB.echoDebug("'" + scriptEntry.getPlayer().getName() + "' did not have enough space in their inventory," + " the rest of the items have been placed on the floor.");
                for (Map.Entry leftoverItem : leftovers.entrySet()) {
                    scriptEntry.getPlayer().getWorld().dropItem(scriptEntry.getPlayer().getLocation(), (ItemStack)leftoverItem.getValue());
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum GiveType {
        ITEM,
        MONEY,
        EXP;

    }
}

