/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class RemoveCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EntityType entityType = null;
        for (String arg : scriptEntry.getArguments()) {
            if (!aH.matchesEntityType(arg)) continue;
            entityType = aH.getEntityFrom(arg);
            dB.echoDebug("...will remove all '%s'.", arg);
        }
        scriptEntry.addObject("entityType", entityType);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        if (entityType == null) {
            scriptEntry.getNPC().getCitizen().destroy();
            dB.echoDebug("...have removed NPC '%s'.", String.valueOf(scriptEntry.getNPC().getCitizen().getId()));
        } else {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!entity.getType().equals((Object)entityType)) continue;
                    entity.remove();
                }
            }
        }
    }
}

