/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.scripts.ScriptEntry;

public class Attribute {
    List<String> attributes;
    ScriptEntry scriptEntry;
    String raw_tag;

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public Attribute(String attributes, ScriptEntry scriptEntry) {
        this.raw_tag = attributes;
        this.scriptEntry = scriptEntry;
        if (attributes == null) {
            this.attributes = Collections.emptyList();
            return;
        }
        Pattern attributer = Pattern.compile("[^\\[\\]\\.]+(\\[.*?\\])?");
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = attributer.matcher(attributes);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        this.attributes = matches;
    }

    public boolean startsWith(String string) {
        string = string.toLowerCase();
        if (this.attributes.isEmpty()) {
            return false;
        }
        return this.attributes.get(0).toLowerCase().startsWith(string);
    }

    public boolean startsWith(String string, int attribute) {
        string = string.toLowerCase();
        if (this.attributes.isEmpty()) {
            return false;
        }
        if (this.attributes.size() < attribute) {
            return false;
        }
        return this.attributes.get(attribute - 1).toLowerCase().startsWith(string);
    }

    public Attribute fulfill(int attributes) {
        for (int x = attributes; x > 0; --x) {
            this.attributes.remove(0);
        }
        return this;
    }

    public boolean hasContext(int attribute) {
        return this.getAttribute(attribute).contains("[");
    }

    public String getContext(int attribute) {
        if (this.hasContext(attribute)) {
            String text = this.getAttribute(attribute);
            Matcher contextMatcher = Pattern.compile("\\[.+\\]").matcher(text);
            if (contextMatcher.find()) {
                return text.substring(contextMatcher.start() + 1);
            }
        }
        return null;
    }

    public int getIntContext(int attribute) {
        try {
            if (this.hasContext(attribute)) {
                return Integer.valueOf(this.getAttribute(attribute).split("\\[", 2)[1].replace("]", ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public String getAttribute(int num) {
        if (this.attributes.size() < num) {
            return "";
        }
        return this.attributes.get(num - 1);
    }
}

