/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.npc.activities.AbstractActivity;
import net.aufdemrand.denizen.npc.activities.core.TaskGoal;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.Goal;

public class TaskActivity
extends AbstractActivity {
    private Map<dNPC, List<TaskGoal>> taskMap = new HashMap<dNPC, List<TaskGoal>>();

    public boolean addGoal(dNPC dNPC2, String[] arguments, int priority) {
        dB.echoDebug("Adding TASK Activity.");
        int delay = 60;
        int repeats = -1;
        String script = null;
        int duration = 50;
        for (String arg : arguments) {
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Integer)) {
                delay = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("REPEATS", arg, aH.ArgumentType.Integer)) {
                repeats = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DURATION", arg, aH.ArgumentType.Integer)) {
                duration = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesScript(arg)) {
                script = aH.getStringFrom(arg);
                continue;
            }
            dB.echoError("Could not match argument '%s'.", arg);
        }
        if (script == null) {
            dB.echoError("No script defined!");
            return false;
        }
        List<TaskGoal> taskGoals = this.taskMap.get(dNPC2);
        if (taskGoals == null) {
            taskGoals = new ArrayList<TaskGoal>();
            this.taskMap.put(dNPC2, taskGoals);
        }
        taskGoals.add(0, new TaskGoal(dNPC2, delay, duration, script, repeats, this));
        dNPC2.getCitizen().getDefaultGoalController().addGoal((Goal)taskGoals.get(0), priority);
        return true;
    }

    public boolean removeGoal(dNPC dNPC2, boolean verbose) {
        if (this.taskMap.containsKey(dNPC2)) {
            for (TaskGoal goal : this.taskMap.get(dNPC2)) {
                dNPC2.getCitizen().getDefaultGoalController().removeGoal((Goal)goal);
            }
            this.taskMap.remove(dNPC2);
            if (verbose) {
                dB.log("Removed Task Activity from NPC.");
            }
            return true;
        }
        if (verbose) {
            dB.log("NPC does not have this activity!");
        }
        return false;
    }

    public void onEnable() {
    }
}

