/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftLivingEntity;
import org.bukkit.entity.Player;

public class HurtCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TargetType targetType = TargetType.PLAYER;
        int amount = 1;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesInteger(arg) || aH.matchesValueArg("amt", arg, aH.ArgumentType.Integer)) {
                amount = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("target", arg, aH.ArgumentType.String)) {
                try {
                    targetType = TargetType.valueOf(aH.getStringFrom(arg).toUpperCase());
                }
                catch (Exception e) {
                    dB.echoError("Invalid TARGET! Valid: NPC, PLAYER");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("target", (Object)targetType).addObject("amount", amount);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        Integer amount = (Integer)scriptEntry.getObject("amount");
        dB.report(this.getName(), aH.debugObj("Target", target == TargetType.PLAYER ? scriptEntry.getPlayer().getName() : scriptEntry.getNPC().getName()) + aH.debugObj("Amount", amount == Integer.MAX_VALUE ? "Full" : String.valueOf(amount)));
        switch (target) {
            case NPC: {
                NPC npc = scriptEntry.getNPC().getCitizen();
                npc.getBukkitEntity().setHealth(npc.getBukkitEntity().getHealth() - amount);
                return;
            }
            case PLAYER: {
                Player player = scriptEntry.getPlayer();
                ((CraftLivingEntity)player).getHandle().setHealth(player.getHealth() - amount);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

