/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dEntity;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;

public class SpawnCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EntityType entityType = null;
        dLocation location = null;
        LivingEntity target = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesEntityType(arg)) {
                entityType = aH.getEntityFrom(arg);
                dB.echoDebug("...entity set to '%s'.", arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesValueArg("TARGET", arg, aH.ArgumentType.Custom)) {
                target = dEntity.valueOf(aH.getStringFrom(arg)).getBukkitEntity();
                dB.echoDebug("...target set to '%s' at " + target.getLocation().getBlockX() + "," + target.getLocation().getBlockY() + "," + target.getLocation().getBlockZ() + "," + target.getLocation().getWorld().getName(), arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entityType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ENTITY);
        }
        scriptEntry.addObject("entityType", entityType);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("target", target);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : scriptEntry.getNPC().getLocation();
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        LivingEntity target = (LivingEntity)scriptEntry.getObject("target");
        Entity entity = location.getWorld().spawnEntity((Location)location, entityType);
        if (target != null && entity instanceof CraftCreature) {
            ((CraftCreature)entity).getHandle().setGoalTarget(((CraftLivingEntity)target).getHandle());
            ((CraftCreature)entity).setTarget(target);
        }
        if (entity instanceof Skeleton) {
            ((Skeleton)entity).getEquipment().setItemInHand(aH.getItemFrom("BOW").getItemStack());
        }
    }
}

