/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class WorldCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Type type = Type.GLOBAL;
        Action action = null;
        SubAction sub = null;
        Player player = scriptEntry.getPlayer();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("player", arg)) {
                player = Bukkit.getServer().getPlayer(aH.getStringFrom("player"));
                type = Type.PLAYER;
                continue;
            }
            if (aH.matchesValueArg("weather", arg, aH.ArgumentType.Custom)) {
                action = Action.WEATHER;
                sub = SubAction.valueOf(aH.getStringFrom(arg).toUpperCase());
                if (sub != null) continue;
                throw new InvalidArgumentsException("Invalid sub action for WEATHER!");
            }
            if (aH.matchesValueArg("time", arg, aH.ArgumentType.Custom)) {
                action = Action.TIME;
                sub = SubAction.valueOf(aH.getStringFrom(arg).toUpperCase());
                if (sub != null) continue;
                throw new InvalidArgumentsException("Invalid sub action for TIME!");
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (type == null) {
            throw new InvalidArgumentsException("Must specify an action! Valid: WEATHER, TIME");
        }
        scriptEntry.addObject("type", (Object)type);
        scriptEntry.addObject("action", (Object)action);
        scriptEntry.addObject("subaction", (Object)sub);
        scriptEntry.addObject("player", player);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        SubAction sub = (SubAction)((Object)scriptEntry.getObject("subaction"));
        Player player = (Player)scriptEntry.getObject("player");
        dB.report(this.getName(), aH.debugObj("Type", type.name()) + aH.debugObj("Action", action.name()) + aH.debugObj("Sub-Action", sub.name()) + (type == Type.PLAYER ? aH.debugObj("Player", player.getName()) : ""));
        block0 : switch (action) {
            case WEATHER: {
                switch (sub) {
                    case SUNNY: {
                        player.getWorld().setThundering(false);
                        player.getWorld().setStorm(false);
                        break;
                    }
                    case THUNDERSTORM: {
                        player.getWorld().setThundering(true);
                    }
                    case STORM: {
                        player.getWorld().setStorm(true);
                        break;
                    }
                    case THUNDERING: {
                        player.getWorld().setThundering(true);
                    }
                }
                break;
            }
            case TIME: {
                switch (sub) {
                    case DAY: {
                        player.getWorld().setTime(0L);
                        break block0;
                    }
                    case NIGHT: {
                        player.getWorld().setTime(13500L);
                        break block0;
                    }
                    case DUSK: {
                        player.getWorld().setTime(12500L);
                        break block0;
                    }
                    case DAWN: {
                        player.getWorld().setTime(23000L);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        GLOBAL,
        PLAYER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubAction {
        DAY,
        NIGHT,
        DUSK,
        DAWN,
        THUNDERING,
        STORM,
        SUNNY,
        THUNDERSTORM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        WEATHER,
        TIME;

    }
}

