/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;

public class DetermineCommand
extends AbstractCommand {
    private static Map<Long, String> outcomes = new ConcurrentHashMap<Long, String>(8, 0.9f, 1);
    public static long uniqueId = 0L;

    public static long getNewId() {
        return ++uniqueId;
    }

    public static boolean hasOutcome(long id) {
        return outcomes.containsKey(id);
    }

    public static String getOutcome(long id) {
        String outcome = outcomes.get(id);
        outcomes.remove(id);
        return outcome;
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String outcome = "false";
        Boolean passively = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("PASSIVELY", arg)) {
                passively = true;
                continue;
            }
            outcome = arg;
        }
        scriptEntry.addObject("outcome", outcome).addObject("passively", passively);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String outcome = (String)scriptEntry.getObject("outcome");
        Boolean passively = (Boolean)scriptEntry.getObject("passively");
        Long uniqueId = (Long)scriptEntry.getObject("reqId");
        if (uniqueId == null) {
            return;
        }
        outcomes.put(uniqueId, outcome);
        if (!passively.booleanValue()) {
            scriptEntry.getResidingQueue().clear();
        }
    }
}

