/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftLivingEntity;
import org.bukkit.entity.Player;

public class HealCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TargetType targetType = TargetType.PLAYER;
        Integer amount = Integer.MAX_VALUE;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesDouble(arg) || aH.matchesValueArg("amt", arg, aH.ArgumentType.Double)) {
                amount = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("target", arg, aH.ArgumentType.String)) {
                try {
                    targetType = TargetType.valueOf(aH.getStringFrom(arg).toUpperCase());
                }
                catch (Exception e) {
                    dB.echoError("Invalid TARGET! Valid: NPC, PLAYER");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("target", (Object)targetType).addObject("amount", amount);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        Double amount = (Double)scriptEntry.getObject("amount");
        dB.report(this.getName(), aH.debugObj("Target", target == TargetType.PLAYER ? scriptEntry.getPlayer().getName() : scriptEntry.getNPC().getName()) + aH.debugObj("Amount", amount == Double.MAX_VALUE ? "Full" : String.valueOf(amount)));
        switch (target) {
            case NPC: {
                NPC npc = scriptEntry.getNPC().getCitizen();
                if (amount == 2.147483647E9) {
                    npc.getBukkitEntity().setHealth(npc.getBukkitEntity().getMaxHealth());
                } else {
                    npc.getBukkitEntity().setHealth(npc.getBukkitEntity().getHealth() + amount);
                }
                return;
            }
            case PLAYER: {
                Player player = scriptEntry.getPlayer().getPlayerEntity();
                if (amount == 2.147483647E9) {
                    player.setHealth(player.getMaxHealth());
                    break;
                }
                ((CraftLivingEntity)player).getHandle().setHealth((float)(player.getHealth() + amount));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

