/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ExplodeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesPrimitive(aH.PrimitiveType.Float) && arg.matchesPrefix("power, p")) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("breakblocks") && arg.matches("breakblocks")) {
                scriptEntry.addObject("breakblocks", "");
                continue;
            }
            if (scriptEntry.hasObject("fire") || !arg.matches("fire")) continue;
            scriptEntry.addObject("fire", "");
        }
        scriptEntry.defaultObject("power", new Element(1.0));
        scriptEntry.defaultObject("location", scriptEntry.hasNPC() ? scriptEntry.getNPC().getLocation() : null, scriptEntry.hasPlayer() ? scriptEntry.getPlayer().getLocation() : null);
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element power = (Element)scriptEntry.getObject("power");
        Boolean breakblocks = scriptEntry.hasObject("breakblocks");
        Boolean fire = scriptEntry.hasObject("fire");
        dB.report(this.getName(), aH.debugObj("location", location.toString()) + aH.debugObj("power", power) + aH.debugObj("breakblocks", breakblocks) + aH.debugObj("fire", fire));
        location.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), power.asFloat(), fire.booleanValue(), breakblocks.booleanValue());
    }
}

