/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.ScriptReloadEvent;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 50;
    private static Map<Player, Set<Integer>> proximityTracker = new ConcurrentHashMap<Player, Set<Integer>>(8, 0.9f, 1);

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            Location toBlockLocation = event.getTo().getBlock().getLocation();
            for (dNPC npc : DenizenAPI.getCurrentInstance().getNPCRegistry().getSpawnedNPCs()) {
                if (!npc.getCitizen().hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(this.name) || !npc.isSpawned() || !npc.getWorld().equals(event.getPlayer().getWorld()) && this.hasExitedProximityOf(event.getPlayer(), npc) || !this.isCloseEnough(event.getPlayer(), npc) && this.hasExitedProximityOf(event.getPlayer(), npc)) continue;
                dPlayer player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
                InteractScriptContainer script = npc.getInteractScriptQuietly(player, this.getClass());
                double entryRadius = npc.getTriggerTrait().getRadius(this.name);
                double exitRadius = npc.getTriggerTrait().getRadius(this.name);
                double moveRadius = npc.getTriggerTrait().getRadius(this.name);
                if (script != null) {
                    try {
                        if (script.hasTriggerOptionFor(this.getClass(), player, null, "ENTRY RADIUS")) {
                            entryRadius = Integer.valueOf(script.getTriggerOptionFor(this.getClass(), player, null, "ENTRY RADIUS")).intValue();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Entry Radius was not an integer.  Assuming " + entryRadius + " as the radius.");
                    }
                    try {
                        if (script.hasTriggerOptionFor(this.getClass(), player, null, "EXIT RADIUS")) {
                            exitRadius = Integer.valueOf(script.getTriggerOptionFor(this.getClass(), player, null, "EXIT RADIUS")).intValue();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Exit Radius was not an integer.  Assuming " + exitRadius + " as the radius.");
                    }
                    try {
                        if (script.hasTriggerOptionFor(this.getClass(), player, null, "MOVE RADIUS")) {
                            moveRadius = Integer.valueOf(script.getTriggerOptionFor(this.getClass(), player, null, "MOVE RADIUS")).intValue();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Move Radius was not an integer.  Assuming " + moveRadius + " as the radius.");
                    }
                }
                dLocation npcLocation = npc.getLocation();
                boolean playerChangedWorlds = false;
                if (npcLocation.getWorld() != event.getPlayer().getWorld()) {
                    playerChangedWorlds = true;
                }
                boolean exitedProximity = this.hasExitedProximityOf(event.getPlayer(), npc);
                double distance = 0.0;
                if (!playerChangedWorlds) {
                    distance = npcLocation.distance(toBlockLocation);
                }
                if (!exitedProximity && (playerChangedWorlds || distance >= exitRadius)) {
                    if (!npc.getTriggerTrait().triggerCooldownOnly(this, player)) continue;
                    this.exitProximityOf(event.getPlayer(), npc);
                    dB.echoDebug(ChatColor.YELLOW + "FOUND! NPC is in EXITING range: '" + npc.getName() + "'");
                    npc.action("exit proximity", player);
                    this.parse(npc, player, script, "EXIT");
                    continue;
                }
                if (exitedProximity && distance <= entryRadius) {
                    if (!npc.getTriggerTrait().triggerCooldownOnly(this, player)) continue;
                    this.enterProximityOf(event.getPlayer(), npc);
                    npc.action("enter proximity", player);
                    this.parse(npc, player, script, "ENTRY");
                    continue;
                }
                if (exitedProximity || !(distance <= moveRadius)) continue;
                npc.action("move proximity", player);
                this.parse(npc, player, script, "MOVE");
            }
        }
    }

    private boolean isCloseEnough(Player player, dNPC npc) {
        Location pLoc = player.getLocation();
        dLocation nLoc = npc.getLocation();
        if (Math.abs(pLoc.getX() - nLoc.getX()) > (double)maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getY() - nLoc.getY()) > (double)maxProximityDistance) {
            return false;
        }
        return !(Math.abs(pLoc.getZ() - nLoc.getZ()) > (double)maxProximityDistance);
    }

    @EventHandler
    public void checkMaxProximities(ScriptReloadEvent event) {
        for (String string : ScriptRegistry._getScriptNames()) {
        }
    }

    private boolean hasExitedProximityOf(Player player, dNPC npc) {
        Set<Integer> existing = proximityTracker.get(player);
        if (existing == null) {
            return true;
        }
        return !existing.contains(npc.getId());
    }

    private void enterProximityOf(Player player, dNPC npc) {
        Set<Integer> npcs = proximityTracker.get(player);
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player, npcs);
        }
        npcs.add(npc.getId());
    }

    private void exitProximityOf(Player player, dNPC npc) {
        Set<Integer> npcs = proximityTracker.get(player);
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player, npcs);
        }
        npcs.remove(npc.getId());
    }
}

