/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.scripts.queues.core.TimedQueue;

public class RunCommand
extends AbstractCommand {
    public String getHelp() {
        return "Runs a script in a new ScriptQueue. By using a new and separatequeue, scripts can be delayed, run instantly, and even used tocreate loops. If wanting to run a series of commands in the samequeue, use the 'inject' command. \n \nUse to start an 'event' that is independent of the current script. \n- run giant_door_open_script \nUse the 'as' argument to attach a player or npc. \n- run start_walking as:n@4 \nName the queue with an 'id' argument. \n- run goal_tracker id:<p.name>'s_goal_tracker \nPut a script's execution off by specifying a delay. \n- run gate_closer delay:10s \nUse run with a delay and 'loop' argument to create a script on a timer. You can even specify the amount of loops. \n- run server_announcement loop 1h \nYou can also attach some definitions to the task script being run. \n- run get_color_of def:i@epic_leather_armor";
    }

    public String getUsage() {
        return "run [script] (path:...) (as:p@player|n@npc) (def:...|...) (id:id_name) (delay:duration) (loop) (q:#)";
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (arg.matchesPrefix("i, id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("p, path")) {
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            if (arg.matches("instant, instantly")) {
                scriptEntry.addObject("instant", Element.TRUE);
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("delay", arg.asType(Duration.class));
                continue;
            }
            if (arg.matches("loop")) {
                scriptEntry.addObject("loop", Element.TRUE);
                continue;
            }
            if (arg.matchesPrefix("q, quantity") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("a, as") && arg.matchesArgumentType(dPlayer.class)) {
                scriptEntry.setPlayer((dPlayer)arg.asType(dPlayer.class));
                continue;
            }
            if (arg.matchesPrefix("a, as") && arg.matchesArgumentType(dNPC.class)) {
                scriptEntry.setNPC((dNPC)arg.asType(dNPC.class));
                continue;
            }
            if (!arg.matchesPrefix("d, def, define, c, context")) continue;
            scriptEntry.addObject("definitions", arg.asType(dList.class));
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        List<ScriptEntry> entries = scriptEntry.hasObject("path") ? script.getContainer().getEntries(scriptEntry.getPlayer(), scriptEntry.getNPC(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.getPlayer(), scriptEntry.getNPC());
        String id = scriptEntry.hasObject("id") ? scriptEntry.getElement("id").asString() : ScriptQueue._getNextId();
        ScriptQueue queue = scriptEntry.hasObject("instant") ? InstantQueue.getQueue(id).addEntries(entries) : TimedQueue.getQueue(id).addEntries(entries);
        if (scriptEntry.hasObject("delay")) {
            queue.delayUntil(System.currentTimeMillis() + ((Duration)scriptEntry.getObject("delay")).getMillis());
        }
        if (scriptEntry.hasObject("definitions")) {
            int x = 1;
            dList definitions = (dList)scriptEntry.getObject("definitions");
            String[] definition_names = null;
            try {
                definition_names = script.getContainer().getString("definitions").split("\\|");
            }
            catch (Exception e) {
                // empty catch block
            }
            for (String definition : definitions) {
                queue.addContext(definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x), definition);
                ++x;
            }
        }
        queue.start();
    }
}

