/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Object> targets = new ArrayList<Object>();
        Duration duration = null;
        int amplifier = 1;
        PotionEffectType potion = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("POWER", arg, aH.ArgumentType.Integer)) {
                amplifier = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("TARGETS, TARGET", arg, aH.ArgumentType.String)) {
                for (String t : aH.getListFrom(arg)) {
                    if (aH.getStringFrom(t).equalsIgnoreCase("PLAYER") && scriptEntry.getPlayer() != null) {
                        if (scriptEntry.getPlayer() == null) {
                            dB.echoError("Cannot add PLAYER as a target! Attached Player is NULL!");
                            continue;
                        }
                        targets.add(scriptEntry.getPlayer().getPlayerEntity());
                        continue;
                    }
                    if (aH.getStringFrom(t).equalsIgnoreCase("NPC") && scriptEntry.getNPC() != null) {
                        if (scriptEntry.getNPC() == null) {
                            dB.echoError("Cannot add NPC as a target! Attached NPC is NULL!");
                            continue;
                        }
                        targets.add(scriptEntry.getNPC().getEntity());
                        continue;
                    }
                    if (aH.getEntityFrom(t) != null) {
                        targets.add(aH.getEntityFrom(t).getLivingEntity());
                        continue;
                    }
                    dB.echoError("Invalid TARGET type or unavailable TARGET object!");
                }
                continue;
            }
            if (potion == null) {
                try {
                    potion = PotionEffectType.getByName((String)aH.getStringFrom(arg));
                }
                catch (Exception e) {
                    dB.echoError("Invalid PotionEffectType!");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (duration == null) {
            duration = new Duration(60);
        }
        if (targets.isEmpty() && scriptEntry.getPlayer() != null) {
            targets.add(scriptEntry.getPlayer().getPlayerEntity());
        }
        if (targets.isEmpty() && scriptEntry.getNPC() != null) {
            targets.add(scriptEntry.getNPC().getEntity());
        }
        if (potion == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "PotionType");
        }
        if (targets.isEmpty()) {
            throw new InvalidArgumentsException("No valid target(s)! Perhaps you specified a non-existing Player or NPCID?");
        }
        PotionEffect potionEffect = new PotionEffect(potion, duration.getTicksAsInt(), amplifier);
        scriptEntry.addObject("potion", potionEffect);
        scriptEntry.addObject("targets", targets);
        scriptEntry.addObject("duration", duration);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List targets = (List)scriptEntry.getObject("targets");
        PotionEffect potion = (PotionEffect)scriptEntry.getObject("potion");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(this.getName(), aH.debugObj("Target(s)", targets.toString()) + aH.debugObj("Potion", potion.getType().getName()) + aH.debugObj("Amplifier", String.valueOf(potion.getAmplifier())) + duration.debug());
        for (LivingEntity target : targets) {
            if (potion.apply(target)) continue;
            dB.echoError("Bukkit was unable to apply '" + potion.getType().getName() + "' to '" + target.toString() + "'.");
        }
    }
}

