/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class NarrateCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        FormatScriptContainer format = null;
        ArrayList<Player> targets = new ArrayList<Player>();
        if (scriptEntry.getArguments().size() > 4) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("FORMAT", arg, aH.ArgumentType.String)) {
                String formatStr = aH.getStringFrom(arg);
                format = ScriptRegistry.getScriptContainerAs(formatStr, FormatScriptContainer.class);
                if (format != null) {
                    dB.echoDebug("... format set to: " + formatStr);
                    continue;
                }
                dB.echoError("... could not find format for: " + formatStr);
                continue;
            }
            if (aH.matchesValueArg("target, targets", arg, aH.ArgumentType.Custom)) {
                Entity entity = null;
                for (String target : aH.getListFrom(arg)) {
                    entity = dEntity.valueOf(target).getBukkitEntity();
                    if (entity != null && entity instanceof Player) {
                        targets.add((Player)entity);
                        continue;
                    }
                    dB.echoError("Invalid target '%s'!", target);
                }
                continue;
            }
            text = arg;
        }
        if (targets.size() == 0) {
            if (scriptEntry.getPlayer() == null || !scriptEntry.getPlayer().isOnline()) {
                throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
            }
            targets.add(scriptEntry.getPlayer().getPlayerEntity());
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text).addObject("format", format).addObject("targets", targets);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List targets = (List)scriptEntry.getObject("targets");
        String text = (String)scriptEntry.getObject("text");
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        dB.report(this.getName(), aH.debugObj("Narrating", text) + aH.debugObj("Targets", targets) + (format != null ? aH.debugObj("Format", format.getName()) : ""));
        for (Player player : targets) {
            player.sendMessage(format != null ? format.getFormattedText(scriptEntry) : text);
        }
    }
}

