/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    static Random random = new Random();
    protected static FilenameFilter scriptsFilter = new FilenameFilter(){

        public boolean accept(File file, String fileName) {
            if (fileName.startsWith(".")) {
                return false;
            }
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSCRIPT");
        }
    };

    public static Location getWalkableLocationNear(Location location, int range) {
        int selected_z;
        int selected_x = random.nextInt(range * 2);
        Location returnable = location.add((double)(selected_x - range), 1.0, (double)((selected_z = random.nextInt(range * 2)) - range));
        if (!Utilities.isWalkable(returnable)) {
            return Utilities.getWalkableLocationNear(location, range);
        }
        return returnable;
    }

    public static boolean isWalkable(Location location) {
        return (location.getBlock().getType() == Material.AIR || location.getBlock().getType() == Material.GRASS) && location.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR;
    }

    public static String arrayToString(String[] input, String glue) {
        String output = "";
        int length = input.length;
        int i = 1;
        for (String s : input) {
            output.concat(s);
            if (++i == length) continue;
            output.concat(glue);
        }
        return output;
    }

    public static String[] wrapWords(String text, int width) {
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while (i + width < sb.length() && (i = sb.lastIndexOf(" ", i + width)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return sb.toString().split("\n");
    }

    public static void talkToNPC(String message, dPlayer player, dNPC npc, double range) {
        String talkFormat = Settings.ChatToNpcFormat().replace("<TEXT>", message).replace("<text>", message).replace("<Text>", message);
        String bystanderFormat = Settings.ChatToNpcOverheardFormat().replace("<TEXT>", message).replace("<text>", message).replace("<Text>", message);
        talkFormat = TagManager.tag(player, npc, talkFormat, false);
        bystanderFormat = TagManager.tag(player, npc, bystanderFormat, false);
        player.getPlayerEntity().sendMessage(talkFormat);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player.getPlayerEntity() || !target.getWorld().equals(player.getPlayerEntity().getWorld()) || !(target.getLocation().distance(player.getPlayerEntity().getLocation()) <= range)) continue;
            target.sendMessage(bystanderFormat);
        }
    }

    public static int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBetween(double a, double b, double c) {
        return b > a ? c > a && c < b : c > b && c < a;
    }

    public static int lastIndexOfLCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public static Player getClosestPlayer(Location location, int range) {
        Player closestPlayer = null;
        double closestDistance = Math.pow(range, 2.0);
        ArrayList<Player> playerList = new ArrayList<Player>(Arrays.asList(Bukkit.getOnlinePlayers()));
        for (Player player : playerList) {
            Location loc = player.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestPlayer = player;
            closestDistance = player.getLocation().distanceSquared(location);
        }
        return closestPlayer;
    }

    public static dNPC getClosestNPC(Location location, int range) {
        dNPC closestNPC = null;
        double closestDistance = Math.pow(range, 2.0);
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getLocation().distanceSquared(location);
        }
        return closestNPC;
    }

    public static Set<dNPC> getClosestNPCs(Location location, int maxRange) {
        maxRange = (int)Math.pow(maxRange, 2.0);
        HashSet<dNPC> closestNPCs = new HashSet<dNPC>();
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < (double)maxRange)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }

    public static boolean checkLocation(LivingEntity entity, Location theLocation, int theLeeway) {
        if (entity.getWorld() != theLocation.getWorld()) {
            return false;
        }
        Location entityLocation = entity.getLocation();
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, int theLeeway) {
        if (!baseLocation.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        Location entityLocation = baseLocation;
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static List<File> listDScriptFiles(File dir, boolean recursive) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!recursive || !file.isDirectory()) continue;
            files.addAll(Utilities.listDScriptFiles(file, recursive));
        }
        return files;
    }

    public static Random getRandom() {
        return random;
    }

    public static void setSignLines(Sign sign, String[] lines) {
        int n = 0;
        for (String line : lines) {
            sign.setLine(n, line);
            ++n;
        }
        sign.update();
    }

    public static void setSignRotation(BlockState signState) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            Block block = signState.getBlock().getRelative(blockFace);
            if (block.getType() == Material.AIR) continue;
            ((org.bukkit.material.Sign)signState.getData()).setFacingDirection(blockFace.getOppositeFace());
            signState.update();
        }
    }
}

