/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.midi;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import net.aufdemrand.denizen.utilities.midi.NoteBlockReceiver;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiUtil {
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 1, 1, 1, 5, 1, 1, 1, 1, 1, 2, 4, 3};

    public static void startSequencer(File file, float tempo, Receiver receiver) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        Sequencer sequencer = MidiSystem.getSequencer(false);
        sequencer.setSequence(MidiSystem.getSequence(file));
        sequencer.open();
        sequencer.setTempoFactor(tempo);
        sequencer.getTransmitter().setReceiver(receiver);
        sequencer.start();
    }

    public static void playMidi(File file, float tempo, Set<Player> listeners) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        NoteBlockReceiver noteblockRecv = new NoteBlockReceiver(listeners);
        MidiUtil.startSequencer(file, tempo, noteblockRecv);
    }

    public static void playMidi(File file, float tempo, Location location) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        NoteBlockReceiver noteblockRecv = new NoteBlockReceiver(location);
        MidiUtil.startSequencer(file, tempo, noteblockRecv);
    }

    public static boolean playMidiQuietly(File file, float tempo, Set<Player> listeners) {
        try {
            MidiUtil.playMidi(file, tempo, listeners);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean playMidiQuietly(File file, float tempo, Location location) {
        try {
            MidiUtil.playMidi(file, tempo, location);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean playMidiQuietly(File file, Set<Player> listeners) {
        return MidiUtil.playMidiQuietly(file, 1.0f, listeners);
    }

    public static boolean playMidiQuietly(File file, Location location) {
        return MidiUtil.playMidiQuietly(file, 1.0f, location);
    }

    public static Sound patchToInstrument(int patch) {
        switch (instruments[patch]) {
            case 1: {
                return Sound.NOTE_BASS_GUITAR;
            }
            case 2: {
                return Sound.NOTE_SNARE_DRUM;
            }
            case 3: {
                return Sound.NOTE_STICKS;
            }
            case 4: {
                return Sound.NOTE_BASS_DRUM;
            }
            case 5: {
                return Sound.NOTE_PLING;
            }
            case 6: {
                return Sound.NOTE_BASS;
            }
        }
        return Sound.NOTE_PIANO;
    }
}

