/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class dInventory
implements dObject {
    private Inventory inventory = null;
    private String prefix = "Inventory";

    @ObjectFetcher(value="in")
    public static dInventory valueOf(String string) {
        return null;
    }

    public static boolean matches(String arg) {
        return false;
    }

    public dInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public dInventory(InventoryType type) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
    }

    public dInventory(InventoryHolder holder) {
        this.inventory = holder.getInventory();
    }

    public dInventory(Player player) {
        this.inventory = player.getInventory();
    }

    public dInventory(BlockState state) {
        if (state instanceof InventoryHolder) {
            this.inventory = ((InventoryHolder)state).getInventory();
        }
    }

    public dInventory(LivingEntity entity) {
        if (entity instanceof InventoryHolder) {
            this.inventory = ((InventoryHolder)entity).getInventory();
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public dInventory add(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.addItem(new ItemStack[]{item});
        }
        return this;
    }

    public int count(ItemStack item, boolean stacks) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || item != null && !invStack.isSimilar(item)) continue;
            if (stacks) {
                ++qty;
                continue;
            }
            qty += invStack.getAmount();
        }
        return qty;
    }

    public dInventory keep(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack invStack : this.inventory) {
            if (invStack == null) continue;
            boolean keep = false;
            for (ItemStack item : items) {
                if (!invStack.isSimilar(item)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.remove(invStack);
        }
        return this;
    }

    public dInventory exclude(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.remove(items).count(null, false);
        }
        return this;
    }

    public dInventory fill(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        int oldCount = this.count(null, false);
        int newCount = -1;
        while (oldCount != newCount) {
            oldCount = newCount;
            newCount = this.add(items).count(null, false);
        }
        return this;
    }

    public dLocation getLocation() {
        if (this.inventory != null) {
            InventoryHolder holder = this.inventory.getHolder();
            if (holder instanceof BlockState) {
                return new dLocation(((BlockState)holder).getLocation());
            }
            if (holder instanceof Player) {
                return new dLocation(((Player)holder).getLocation());
            }
        }
        return null;
    }

    public dInventory remove(ItemStack[] items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            this.inventory.removeItem(new ItemStack[]{item});
        }
        return this;
    }

    public dInventory removeBook(ItemStack book) {
        if (this.inventory == null || book == null) {
            return this;
        }
        int qty = book.getAmount();
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        for (ItemStack invStack : this.inventory) {
            BookMeta invMeta;
            if (qty == 0) break;
            if (invStack == null || !(invStack.getItemMeta() instanceof BookMeta) || !(invMeta = (BookMeta)invStack.getItemMeta()).getAuthor().equalsIgnoreCase(bookMeta.getAuthor()) || !invMeta.getTitle().equalsIgnoreCase(bookMeta.getTitle())) continue;
            if (qty - invStack.getAmount() < 0) {
                invStack.setAmount((qty - invStack.getAmount()) * -1);
                continue;
            }
            this.inventory.removeItem(new ItemStack[]{invStack});
            qty -= invStack.getAmount();
        }
        return this;
    }

    public void replace(dInventory destination) {
        if (this.inventory == null || destination == null) {
            return;
        }
        if (destination.getSize() < this.getSize()) {
            destination.clear();
            destination.add(this.getContents());
        } else {
            destination.setContents(this.getContents());
        }
    }

    public void clear() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    public ItemStack[] getContents() {
        if (this.inventory != null) {
            return this.inventory.getContents();
        }
        return new ItemStack[0];
    }

    public InventoryType getInventoryType() {
        return this.inventory.getType();
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void remove(ItemStack item) {
        this.inventory.remove(item);
    }

    public void setContents(ItemStack[] contents) {
        this.inventory.setContents(contents);
    }

    public String getType() {
        return "Inventory";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dInventory setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return null;
    }

    public boolean isUnique() {
        return false;
    }

    public String identify() {
        return null;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
            int qty = 1;
            if (attribute.getAttribute(2).startsWith("qty") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                qty = attribute.getIntContext(2);
            }
            return new Element(this.getInventory().containsAtLeast(dItem.valueOf(attribute.getContext(1)).getItemStack(), qty)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("qty")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(String.valueOf(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), false))).getAttribute(attribute.fulfill(1));
            }
            return new Element(String.valueOf(this.count(null, false))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("size")) {
            return new Element(String.valueOf(this.getSize())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("stacks")) {
            if (attribute.hasContext(1) && dItem.matches(attribute.getContext(1))) {
                return new Element(String.valueOf(this.count(dItem.valueOf(attribute.getContext(1)).getItemStack(), true))).getAttribute(attribute.fulfill(1));
            }
            return new Element(String.valueOf(this.count(null, true))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element(this.getInventory().getType().name()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }
}

