/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class SignCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class).setPrefix("location"));
                continue;
            }
            if (scriptEntry.hasObject("text") || !arg.matchesArgumentType(dList.class)) continue;
            scriptEntry.addObject("text", arg.asType(dList.class));
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a Sign location!");
        }
        if (!scriptEntry.hasObject("type")) {
            scriptEntry.addObject("type", (Object)Type.SIGN_POST);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        dList text = (dList)scriptEntry.getObject("text");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dB.report(this.getName(), type.name() + ", " + aH.debugObj("location", location) + aH.debugObj("text", text));
        Block sign = location.getBlock();
        sign.setType(Material.valueOf((String)type.name()));
        BlockState signState = sign.getState();
        Utilities.setSignLines((Sign)signState, text.toArray());
        Utilities.setSignRotation(signState);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SIGN_POST,
        WALL_SIGN;

    }
}

