/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_6_R2.Entity;
import net.minecraft.server.v1_6_R2.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftLivingEntity;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;

public class dEntity
implements dObject {
    static final Pattern entity_by_id = Pattern.compile("(n@|e@|p@)(.+)", 2);
    static final Pattern entity_with_data = Pattern.compile("(\\w+),?(\\w+)?,?(\\w+)?", 2);
    public static Map<String, dEntity> uniqueObjects = new HashMap<String, dEntity>();
    private org.bukkit.entity.Entity entity = null;
    private EntityType entity_type = null;
    private String data1 = null;
    private String data2 = null;
    private DespawnedEntity despawned_entity = null;
    private String prefix = "Entity";

    public static boolean isSaved(String id) {
        return uniqueObjects.containsKey(id.toUpperCase());
    }

    public static boolean isSaved(dEntity entity) {
        return uniqueObjects.containsValue(entity);
    }

    public static dEntity getSaved(String id) {
        if (uniqueObjects.containsKey(id.toUpperCase())) {
            return uniqueObjects.get(id.toUpperCase());
        }
        return null;
    }

    public static String getSaved(dEntity entity) {
        for (Map.Entry<String, dEntity> i : uniqueObjects.entrySet()) {
            if (i.getValue() != entity) continue;
            return i.getKey();
        }
        return null;
    }

    public static void saveAs(dEntity entity, String id) {
        if (entity == null) {
            return;
        }
        uniqueObjects.put(id.toUpperCase(), entity);
    }

    public static void remove(String id) {
        uniqueObjects.remove(id.toUpperCase());
    }

    @ObjectFetcher(value="e")
    public static dEntity valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("RANDOM")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[Utilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new dEntity(randomType, "RANDOM");
        }
        Matcher m = entity_by_id.matcher(string);
        if (m.matches()) {
            String entityGroup = m.group(1).toUpperCase();
            if (entityGroup.matches("N@")) {
                NPC returnable = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(m.group(2)).intValue());
                if (returnable != null) {
                    return new dEntity((org.bukkit.entity.Entity)returnable.getBukkitEntity());
                }
                dB.echoError("Invalid NPC! '" + entityGroup + "' could not be found. Has it been despawned or killed?");
            } else if (entityGroup.matches("P@")) {
                Player returnable = aH.getPlayerFrom(m.group(2)).getPlayerEntity();
                if (returnable != null) {
                    return new dEntity((org.bukkit.entity.Entity)returnable);
                }
                dB.echoError("Invalid Player! '" + entityGroup + "' could not be found. Has the player logged off?");
            } else if (aH.matchesInteger(m.group(2))) {
                int entityID = Integer.valueOf(m.group(2));
                CraftEntity entity = null;
                for (World world : Bukkit.getWorlds()) {
                    Entity nmsEntity = ((CraftWorld)world).getHandle().getEntity(entityID);
                    if (nmsEntity == null) {
                        return null;
                    }
                    entity = nmsEntity.getBukkitEntity();
                    if (entity == null) continue;
                    break;
                }
                if (entity != null) {
                    return new dEntity((org.bukkit.entity.Entity)entity);
                }
            } else if (dEntity.isSaved(m.group(2))) {
                return dEntity.getSaved(m.group(2));
            }
        }
        if (ScriptRegistry.containsScript(string = string.replace("e@", ""), EntityScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(m.group(0), EntityScriptContainer.class).getEntityFrom();
        }
        m = entity_with_data.matcher(string);
        if (m.matches()) {
            String data1 = null;
            String data2 = null;
            if (m.group(2) != null) {
                data1 = m.group(2).toUpperCase();
            }
            if (m.group(3) != null) {
                data2 = m.group(3).toUpperCase();
            }
            for (EntityType type : EntityType.values()) {
                if (!type.name().equalsIgnoreCase(m.group(1))) continue;
                return new dEntity(type, data1, data2);
            }
        }
        dB.log("valueOf dEntity returning null: " + string);
        return null;
    }

    public static boolean matches(String arg) {
        Matcher m = entity_by_id.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if ((arg = arg.replace("e@", "")).equalsIgnoreCase("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        m = entity_with_data.matcher(arg);
        if (m.matches()) {
            for (EntityType type : EntityType.values()) {
                if (!type.name().equalsIgnoreCase(m.group(1))) continue;
                return true;
            }
        }
        return false;
    }

    public dEntity(org.bukkit.entity.Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entity_type = entity.getType();
        } else {
            dB.echoError("Entity referenced is null!");
        }
    }

    public dEntity(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    public dEntity(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    public dEntity(EntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
            this.data2 = data2;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    public EntityType getEntityType() {
        return this.entity_type;
    }

    public org.bukkit.entity.Entity getBukkitEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public NPC getNPC() {
        return CitizensAPI.getNPCRegistry().getNPC(this.getBukkitEntity());
    }

    public boolean isNPC() {
        return CitizensAPI.getNPCRegistry().isNPC(this.getBukkitEntity());
    }

    public boolean isGeneric() {
        return this.identify().matches("e@\\D+");
    }

    public void spawnAt(Location location) {
        if (this.entity != null && this.isUnique()) {
            this.entity.teleport(location);
        } else if (this.entity_type != null) {
            if (this.despawned_entity != null) {
                if (this.despawned_entity.custom_script == null) {
                    this.entity = location.getWorld().spawnEntity(location, this.entity_type);
                }
                this.getLivingEntity().teleport(location);
                this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                this.despawned_entity = null;
            } else {
                org.bukkit.entity.Entity ent = null;
                if (this.entity_type.name().matches("FALLING_BLOCK")) {
                    Material material = null;
                    if (this.data1 != null && dMaterial.matches(this.data1)) {
                        material = dMaterial.valueOf(this.data1).getMaterial();
                        while (this.data1.equals("RANDOM") && (!material.isBlock() || material == Material.AIR || material == Material.PORTAL || material == Material.ENDER_PORTAL)) {
                            material = dMaterial.valueOf(this.data1).getMaterial();
                        }
                    }
                    if (material == null || !material.isBlock()) {
                        material = Material.SAND;
                    }
                    byte materialData = 0;
                    if (this.data2 != null && aH.matchesInteger(this.data2)) {
                        materialData = (byte)aH.getIntegerFrom(this.data2);
                    }
                    this.entity = ent = location.getWorld().spawnFallingBlock(location, material, materialData);
                } else {
                    this.entity = ent = location.getWorld().spawnEntity(location, this.entity_type);
                    if (this.data1 != null) {
                        try {
                            if (ent instanceof Creeper && this.data1.equalsIgnoreCase("POWERED")) {
                                ((Creeper)this.entity).setPowered(true);
                            } else if (ent instanceof Enderman && dMaterial.matches(this.data1)) {
                                ((Enderman)this.entity).setCarriedMaterial(dMaterial.valueOf(this.data1).getMaterialData());
                            } else if (ent instanceof Horse) {
                                this.setSubtype("org.bukkit.entity.Horse", "org.bukkit.entity.Horse$Variant", "setVariant", this.data1);
                                if (this.data2 != null) {
                                    this.setSubtype("org.bukkit.entity.Horse", "org.bukkit.entity.Horse$Color", "setColor", this.data2);
                                }
                            } else if (ent instanceof Ocelot) {
                                this.setSubtype("org.bukkit.entity.Ocelot", "org.bukkit.entity.Ocelot$Type", "setCatType", this.data1);
                            } else if (ent instanceof Sheep) {
                                this.setSubtype("org.bukkit.entity.Sheep", "org.bukkit.DyeColor", "setColor", this.data1);
                            } else if (ent instanceof Skeleton) {
                                this.setSubtype("org.bukkit.entity.Skeleton", "org.bukkit.entity.Skeleton$SkeletonType", "setSkeletonType", this.data1);
                                if (!dItem.matches(this.data2)) {
                                    this.data2 = "bow";
                                }
                                ((Skeleton)this.entity).getEquipment().setItemInHand(dItem.valueOf(this.data2).getItemStack());
                            } else if (ent instanceof Slime && aH.matchesInteger(this.data1)) {
                                ((Slime)this.entity).setSize(aH.getIntegerFrom(this.data1));
                            } else if (ent instanceof Villager) {
                                this.setSubtype("org.bukkit.entity.Villager", "org.bukkit.entity.Villager$Profession", "setProfession", this.data1);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } else {
            dB.echoError("Cannot spawn a null dEntity!");
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity != null) {
            dB.echoDebug("Entity " + this.identify() + " is already spawned!");
        } else {
            dB.echoError("Cannot respawn a null dEntity!");
        }
    }

    public boolean isSpawned() {
        return this.entity != null;
    }

    public void remove() {
        this.entity.remove();
    }

    public dEntity rememberAs(String id) {
        dEntity.saveAs(this, id);
        return this;
    }

    public void teleport(Location location) {
        this.getBukkitEntity().teleport(location);
    }

    public void target(LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)this.entity).getHandle().setGoalTarget(nmsTarget);
        ((CraftCreature)this.entity).setTarget(target);
    }

    public void setSubtype(String entityName, String typeName, String method, String value) throws Exception {
        Class<?> entityClass = Class.forName(entityName);
        Class<?> typeClass = Class.forName(typeName);
        ?[] types = typeClass.getEnumConstants();
        if (value.matches("RANDOM")) {
            entityClass.getMethod(method, typeClass).invoke((Object)this.entity, types[Utilities.getRandom().nextInt(types.length)]);
        } else {
            for (Object type : types) {
                if (!type.toString().equalsIgnoreCase(value)) continue;
                entityClass.getMethod(method, typeClass).invoke((Object)this.entity, type);
                break;
            }
        }
    }

    public String getType() {
        return "Entity";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dEntity setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public String identify() {
        if (this.getBukkitEntity() != null) {
            if (this.isNPC()) {
                return "n@" + this.getNPC().getId();
            }
            if (this.getBukkitEntity() instanceof Player) {
                return "p@" + ((Player)this.getBukkitEntity()).getName();
            }
        }
        if (this.isUnique()) {
            return "e@" + dEntity.getSaved(this);
        }
        if (this.isSpawned()) {
            return "e@" + this.getBukkitEntity().getEntityId();
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.name();
        }
        return "null";
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        if (this.entity instanceof Player) {
            return true;
        }
        if (this.isNPC()) {
            return true;
        }
        return dEntity.isSaved(this);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (this.entity == null) {
            dB.echoDebug("dEntity has returned null.");
            return "null";
        }
        if (attribute.startsWith("get_vehicle")) {
            if (this.getBukkitEntity().isInsideVehicle()) {
                return new dEntity(this.getBukkitEntity().getVehicle()).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("custom_name")) {
            if (this.getLivingEntity().getCustomName() == null) {
                return "null";
            }
            return new Element(this.getLivingEntity().getCustomName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            if (this.isNPC()) {
                return new Element(this.getNPC().getName()).getAttribute(attribute.fulfill(1));
            }
            if (this.entity instanceof Player) {
                return new Element(((Player)this.entity).getName()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.entity.getType().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_type")) {
            if (this.entity instanceof CraftAnimals && !(this.entity instanceof Pig)) {
                return new Element("HORSE").getAttribute(attribute.fulfill(1));
            }
            return new Element(this.entity_type.toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("custom_id")) {
            if (CustomNBT.hasCustomNBT(this.getLivingEntity(), "denizen-script-id")) {
                return new dScript(CustomNBT.getCustomNBT(this.getLivingEntity(), "denizen-script-id")).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getBukkitEntity().getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            return new dLocation(this.getLivingEntity().getTargetBlock(null, range).getLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location.standing_on")) {
            return new dLocation(this.entity.getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            if (this.entity instanceof Player) {
                dLocation location = new dLocation(this.entity.getLocation());
                location.setYaw(location.getYaw() - 90.0f);
                return location.getAttribute(attribute.fulfill(1));
            }
            return new dLocation(this.entity.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.formatted")) {
            double maxHealth = this.getLivingEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            if ((double)((float)this.getLivingEntity().getHealth()) / maxHealth < 0.1) {
                return new Element("dying").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getLivingEntity().getHealth()) / maxHealth < 0.4) {
                return new Element("seriously wounded").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getLivingEntity().getHealth()) / maxHealth < 0.75) {
                return new Element("injured").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.getLivingEntity().getHealth()) / maxHealth < 1.0) {
                return new Element("scraped").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            double maxHealth = this.getLivingEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(String.valueOf((double)((float)this.getLivingEntity().getHealth()) / maxHealth * 100.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.max")) {
            return new Element(String.valueOf(this.getLivingEntity().getMaxHealth())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new Element(String.valueOf(this.getLivingEntity().getHealth())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_inside_vehicle")) {
            return new Element(String.valueOf(this.entity.isInsideVehicle())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return new dPlayer((OfflinePlayer)this.getLivingEntity().getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage.cause")) {
            return new Element(String.valueOf(this.entity.getLastDamageCause().getCause().toString())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.amount")) {
            return new Element(String.valueOf(this.getLivingEntity().getLastDamage())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.duration")) {
            return new Duration((long)this.getLivingEntity().getNoDamageTicks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.entity.getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items")) {
            return new Element(String.valueOf(this.getLivingEntity().getCanPickupItems())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eid")) {
            return new Element(String.valueOf(this.entity.getEntityId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(String.valueOf(this.entity.getFallDistance())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(String.valueOf(this.entity.getUniqueId().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            // empty if block
        }
        if (attribute.startsWith("equipment")) {
            return new dInventory(this.getLivingEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return new dWorld(this.entity.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element(this.getType()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(dEntity entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT(entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT(entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

