/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizen.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldScriptHelper
implements Listener {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    private Map<String, Integer> current_time = new HashMap<String, Integer>();

    public WorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> eventNames, dNPC npc, Player player, Map<String, Object> context) {
        String determination = "none";
        for (WorldScriptContainer script : world_scripts.values()) {
            if (script == null) continue;
            for (String eventName : eventNames) {
                List<ScriptEntry> entries;
                if (!script.contains("EVENTS.ON " + eventName.toUpperCase()) || (entries = script.getEntries(player != null ? new dPlayer((OfflinePlayer)player) : null, npc, "events.on " + eventName)).isEmpty()) continue;
                dB.report("Event", aH.debugObj("Type", "On " + eventName) + script.getAsScriptArg().debug() + (npc != null ? aH.debugObj("NPC", npc.toString()) : "") + (player != null ? aH.debugObj("Player", player.getName()) : "") + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                dB.echoDebug(dB.DebugElement.Header, "Building event 'On " + eventName.toUpperCase() + "' for " + script.getName());
                if (context != null) {
                    for (Map.Entry<String, Object> entry : context.entrySet()) {
                        ScriptBuilder.addObjectToEntries(entries, entry.getKey(), entry.getValue());
                    }
                }
                long id = DetermineCommand.getNewId();
                ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                InstantQueue.getQueue(null).addEntries(entries).start();
                if (!DetermineCommand.hasOutcome(id)) continue;
                determination = DetermineCommand.getOutcome(id);
            }
        }
        return determination;
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Block block = event.getBlock();
        String blockType = block.getType().name();
        context.put("location", new dLocation(block.getLocation()));
        context.put("type", new Element(blockType));
        dItem item = new dItem(event.getPlayer().getItemInHand());
        ArrayList<String> events = new ArrayList<String>();
        events.add("player breaks block");
        events.add("player breaks " + blockType);
        events.add("player breaks block with " + item.identify());
        events.add("player breaks " + blockType + " with " + item.identify());
        if (!item.identify().equals(item.identify().split(":")[0])) {
            events.add("player breaks block with " + item.identify().split(":")[0]);
            events.add("player breaks " + blockType + " with " + item.identify().split(":")[0]);
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("DROP")) {
            event.setCancelled(true);
            if (aH.getStringFrom(determination).equalsIgnoreCase("nothing")) {
                block.getDrops().clear();
            } else {
                List<dObject> newItems = dList.valueOf(aH.getStringFrom(determination)).filter(dItem.class);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (dObject newItem : newItems) {
                    block.getWorld().dropItemNaturally(block.getLocation(), ((dItem)newItem).getItemStack());
                    drops.add(((dItem)newItem).getItemStack());
                }
            }
            block.setType(Material.AIR);
        }
    }

    @EventHandler
    public void blockBurn(BlockBurnEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block burns", event.getBlock().getType().name() + " burns"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockIgnite(BlockIgniteEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block ignites", event.getBlock().getType().name() + " ignites"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPhysics(BlockPhysicsEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block moves", event.getBlock().getType().name() + " moves"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockPlace(BlockPlaceEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player places block", "player places " + event.getBlock().getType().name()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockRedstone(BlockRedstoneEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        ArrayList<String> events = new ArrayList<String>();
        if (event.getNewCurrent() > 0) {
            events.add("block powered");
            events.add(event.getBlock().getType().name() + " powered");
        } else {
            events.add("block unpowered");
            events.add(event.getBlock().getType().name() + " unpowered");
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler
    public void blockFromTo(BlockFromToEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("type", new Element(event.getBlock().getType().name()));
        context.put("destination", new dLocation(event.getToBlock().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("block spreads", event.getBlock().getType().name() + " spreads"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void signChange(SignChangeEvent event) {
        final HashMap<String, dObject> context = new HashMap<String, dObject>();
        final Player player = event.getPlayer();
        final Block block = event.getBlock();
        Sign sign = (Sign)block.getState();
        final String[] oldLines = sign.getLines();
        context.put("old", new dList(Arrays.asList(oldLines)));
        context.put("location", new dLocation(block.getLocation()));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                Sign sign = (Sign)block.getState();
                context.put("new", new dList(Arrays.asList(sign.getLines())));
                String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes sign"), null, player, context);
                if (determination.toUpperCase().startsWith("CANCELLED")) {
                    Utilities.setSignLines(sign, oldLines);
                }
            }
        }, 1L);
    }

    public void serverStartEvent() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                WorldScriptHelper.this.timeEvent();
            }
        }, Settings.WorldScriptTimeEventResolution().getTicks(), Settings.WorldScriptTimeEventResolution().getTicks());
        WorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey(world.getName()) && this.current_time.get(world.getName()) == hour) continue;
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("time", new Element(String.valueOf(hour)));
            context.put("world", new dWorld(world));
            WorldScriptHelper.doEvents(Arrays.asList("time changes in " + world.getName(), hour + ":00 in " + world.getName()), null, null, context);
            this.current_time.put(world.getName(), hour);
        }
    }

    @EventHandler
    public void hangingBreak(HangingBreakEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Player player = null;
        dNPC npc = null;
        String hangingType = event.getEntity().getType().name();
        String cause = event.getCause().name();
        context.put("hanging", new dEntity((Entity)event.getEntity()));
        context.put("cause", new Element(cause));
        ArrayList<String> events = new ArrayList<String>();
        events.add("hanging breaks");
        events.add("hanging breaks because " + cause);
        events.add(hangingType + " breaks");
        events.add(hangingType + " breaks because " + cause);
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent subEvent = (HangingBreakByEntityEvent)event;
            Entity entity = subEvent.getRemover();
            String entityType = entity.getType().name();
            if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
                npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
                context.put("entity", npc);
                entityType = "npc";
            } else if (entity instanceof Player) {
                player = (Player)entity;
                context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            } else {
                context.put("entity", new dEntity(entity));
            }
            events.add("entity breaks hanging");
            events.add("entity breaks hanging because " + cause);
            events.add("entity breaks " + hangingType);
            events.add("entity breaks " + hangingType + " because " + cause);
            events.add(entityType + " breaks hanging");
            events.add(entityType + " breaks hanging because " + cause);
            events.add(entityType + " breaks " + hangingType);
            events.add(entityType + " breaks " + hangingType + " because " + cause);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LivingEntity entity = event.getEntity();
        context.put("entity", new dEntity((Entity)entity));
        context.put("reason", new Element(event.getSpawnReason().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity spawns", "entity spawns because " + event.getSpawnReason().name(), entity.getType().name() + " spawns", entity.getType().name() + " spawns because " + event.getSpawnReason().name()), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityCombust(EntityCombustEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity));
        context.put("duration", new Duration((long)event.getDuration()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity combusts", entity.getType().name() + " combusts"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityDamage(EntityDamageEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        boolean isFatal = false;
        Entity entity = event.getEntity();
        String entityType = entity.getType().name();
        String cause = event.getCause().name();
        Player player = null;
        dNPC npc = null;
        if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
            npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
            context.put("entity", npc);
            entityType = "npc";
        } else if (entity instanceof Player) {
            player = (Player)entity;
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
        } else {
            context.put("entity", new dEntity(entity));
        }
        context.put("damage", new Element(event.getDamage()));
        context.put("cause", new Element(event.getCause().name()));
        if (entity instanceof LivingEntity && event.getDamage() >= ((LivingEntity)entity).getHealth()) {
            isFatal = true;
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity damaged");
        events.add("entity damaged by " + cause);
        events.add(entityType + " damaged");
        events.add(entityType + " damaged by " + cause);
        if (isFatal) {
            events.add("entity killed");
            events.add("entity killed by " + cause);
            events.add(entityType + " killed");
            events.add(entityType + " killed by " + cause);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
            Player subPlayer = null;
            dNPC subNPC = null;
            Entity damager = subEvent.getDamager();
            String damagerType = damager.getType().name();
            if (CitizensAPI.getNPCRegistry().isNPC(damager)) {
                subNPC = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
                context.put("damager", DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(damager)));
                damagerType = "npc";
                if (npc == null) {
                    npc = subNPC;
                }
            } else if (damager instanceof Player) {
                subPlayer = (Player)damager;
                context.put("damager", new dPlayer((OfflinePlayer)((Player)damager)));
                if (player == null) {
                    player = subPlayer;
                }
            } else if (damager instanceof Projectile) {
                context.put("shooter", new dEntity((Entity)((Projectile)damager).getShooter()));
                context.put("damager", new dEntity(damager));
            } else {
                context.put("damager", new dEntity(damager));
            }
            events.add("entity damaged by entity");
            events.add("entity damaged by " + damagerType);
            events.add(entityType + " damaged by entity");
            events.add(entityType + " damaged by " + damagerType);
            ArrayList<String> subEvents = new ArrayList<String>();
            subEvents.add("entity damages entity");
            subEvents.add("entity damages " + entityType);
            subEvents.add(damagerType + " damages entity");
            subEvents.add(damagerType + " damages " + entityType);
            if (isFatal) {
                events.add("entity killed by entity");
                events.add("entity killed by " + damagerType);
                events.add(entityType + " killed by entity");
                events.add(entityType + " killed by " + damagerType);
                subEvents.add("entity kills entity");
                subEvents.add("entity kills " + entityType);
                subEvents.add(damagerType + " kills entity");
                subEvents.add(damagerType + " kills " + entityType);
            }
            if ((determination = WorldScriptHelper.doEvents(subEvents, subNPC, subPlayer, context)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            }
            if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Double)) {
                event.setDamage(aH.getDoubleFrom(determination));
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityExplode(EntityExplodeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        context.put("entity", new dEntity(entity));
        context.put("location", new dLocation(event.getLocation()));
        String blocks = "";
        for (Block block : event.blockList()) {
            blocks = blocks + new dLocation(block.getLocation()) + "|";
        }
        context.put("blocks", blocks.length() > 0 ? new dList(blocks) : null);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explodes", entity.getType().name() + " explodes"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityRegainHealth(EntityRegainHealthEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        String entityType = entity.getType().name();
        context.put("reason", new Element(event.getRegainReason().name()));
        context.put("amount", new Element(event.getAmount()));
        Player player = null;
        dNPC npc = null;
        if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
            npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
            context.put("entity", npc);
            entityType = "npc";
        } else if (entity instanceof Player) {
            player = (Player)entity;
            context.put("entity", new dPlayer((OfflinePlayer)player));
        } else {
            context.put("entity", new dEntity(entity));
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity heals", "entity heals because " + event.getRegainReason().name(), entityType + " heals", entityType + " heals because " + event.getRegainReason().name()), npc, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (aH.matchesValueArg("AMOUNT", determination, aH.ArgumentType.Double)) {
            event.setAmount(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void entityTame(EntityTameEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        LivingEntity entity = event.getEntity();
        context.put("entity", new dEntity((Entity)entity));
        Player player = null;
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity tamed");
        events.add(entity.getType().name() + " tamed");
        if (event.getOwner() instanceof Player) {
            player = (Player)event.getOwner();
            events.add("player tames entity");
            events.add("player tames " + entity.getType().name());
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityTarget(EntityTargetEvent event) {
        dEntity newTarget;
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        Entity target = event.getTarget();
        Player player = null;
        String reason = event.getReason().name();
        String entityType = entity.getType().name();
        context.put("entity", new dEntity(entity));
        context.put("reason", new Element(reason));
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity targets");
        events.add("entity targets because " + reason);
        events.add(entityType + " targets because " + reason);
        if (target != null) {
            if (event.getTarget() instanceof Player) {
                player = (Player)target;
                context.put("target", new dPlayer((OfflinePlayer)player));
            } else {
                context.put("target", new dEntity(target));
            }
            String targetType = target.getType().name();
            events.add("entity targets entity");
            events.add("entity targets entity because " + reason);
            events.add("entity targets " + targetType);
            events.add("entity targets " + targetType + " because " + reason);
            events.add(entityType + " targets entity");
            events.add(entityType + " targets entity because " + reason);
            events.add(entityType + " targets " + targetType);
            events.add(entityType + " targets " + targetType + " because " + reason);
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("TARGET") && (newTarget = dEntity.valueOf(aH.getStringFrom(determination))).getBukkitEntity() != null) {
            event.setTarget(newTarget.getBukkitEntity());
        }
    }

    @EventHandler
    public void entityTeleport(EntityTeleportEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity));
        context.put("origin", new dLocation(event.getFrom()));
        context.put("destination", new dLocation(event.getTo()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity teleports", entity.getType().name() + " teleports"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void explosionPrimeEvent(ExplosionPrimeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntity();
        context.put("entity", new dEntity(entity));
        context.put("radius", new Element(String.valueOf(event.getRadius())));
        context.put("fire", new Element(event.getFire()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity explosion primes", entity.getType().name() + " explosion primes"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void foodLevelChange(FoodLevelChangeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HumanEntity entity = event.getEntity();
        context.put("entity", entity instanceof Player ? new dPlayer((OfflinePlayer)((Player)entity)) : new dEntity((Entity)entity));
        String determination = WorldScriptHelper.doEvents(Arrays.asList(entity.getType().name() + " changes food level"), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (aH.matchesValueArg("FOOD", determination, aH.ArgumentType.Integer)) {
            event.setFoodLevel(aH.getIntegerFrom(determination));
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        dItem item = new dItem(event.getCurrentItem());
        Player player = (Player)event.getWhoClicked();
        String type = event.getInventory().getType().name();
        String click = event.getClick().name();
        context.put("item", item);
        context.put("inventory", new dInventory(event.getInventory()));
        context.put("click", new Element(click));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player clicks in inventory");
        events.add("player clicks in " + type + " inventory");
        String interaction = "player " + click + " clicks";
        events.add(interaction + " in inventory");
        events.add(interaction + " in " + type + " inventory");
        if (item.getItemStack() != null) {
            events.add(interaction + " on " + item.identify() + " in inventory");
            events.add(interaction + " on " + item.identify() + " in " + type + " inventory");
            if (!item.identify().equals(item.identify().split(":")[0])) {
                events.add(interaction + " on " + item.identify().split(":")[0] + " in inventory");
                events.add(interaction + " on " + item.identify().split(":")[0] + " in " + type + " inventory");
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, player, context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerChat(final AsyncPlayerChatEvent event) {
        final HashMap<String, Element> context = new HashMap<String, Element>();
        context.put("message", new Element(event.getMessage()));
        Callable<String> call = new Callable<String>(){

            @Override
            public String call() {
                return WorldScriptHelper.doEvents(Arrays.asList("player chats"), null, event.getPlayer(), context);
            }
        };
        String determination = null;
        try {
            determination = event.isAsynchronous() ? (String)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get() : (String)call.call();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (determination == null) {
            return;
        }
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void bedEnterEvent(PlayerBedEnterEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player enters bed"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void bedLeaveEvent(PlayerBedLeaveEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        WorldScriptHelper.doEvents(Arrays.asList("player leaves bed"), null, event.getPlayer(), context);
    }

    @EventHandler
    public void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player empties bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("ITEM_IN_HAND")) {
            ItemStack is = dItem.valueOf(aH.getStringFrom(determination)).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerBucketFill(PlayerBucketFillEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("item", new dItem(event.getBucket()));
        context.put("location", new dLocation(event.getBlockClicked().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player fills bucket"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("ITEM_IN_HAND")) {
            ItemStack is = dItem.valueOf(aH.getStringFrom(determination)).getItemStack();
            event.setItemStack(is != null ? is : new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void playerCommandEvent(PlayerCommandPreprocessEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        dPlayer player = dPlayer.valueOf(event.getPlayer().getName());
        List<String> args = Arrays.asList(aH.buildArgs(TagManager.tag(player, null, event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : "")));
        dList args_list = new dList(args);
        String command = event.getMessage().split(" ")[0].replace("/", "").toUpperCase();
        context.put("args", args_list);
        context.put("command", new Element(command));
        context.put("raw_args", new Element(event.getMessage().split(" ").length > 1 ? event.getMessage().split(" ", 2)[1] : ""));
        context.put("server", Element.FALSE);
        String determination = WorldScriptHelper.doEvents(Arrays.asList("command", command + " command"), null, event.getPlayer(), context).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", new Element(event.getDeathMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player dies", "player death"), null, event.getEntity(), context);
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setDeathMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void playerFish(PlayerFishEvent event) {
        String determination;
        Entity entity = event.getCaught();
        String state = event.getState().name();
        dNPC npc = null;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("hook", new dEntity((Entity)event.getHook()));
        context.put("state", new Element(state));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player fishes");
        events.add("player fishes while " + state);
        if (entity != null) {
            String entityType = entity.getType().name();
            if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
                npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
                context.put("entity", npc);
                entityType = "npc";
            } else if (entity instanceof Player) {
                context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            } else {
                context.put("entity", new dEntity(entity));
            }
            events.add("player fishes " + entityType);
            events.add("player fishes " + entityType + " while " + state);
        }
        if ((determination = WorldScriptHelper.doEvents(events, npc, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerGameModeChange(PlayerGameModeChangeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("gamemode", new Element(event.getNewGameMode().name()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player changes gamemode", "player changes gamemode to " + event.getNewGameMode().name()), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        String determination;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Action action = event.getAction();
        dItem item = null;
        ArrayList<String> events = new ArrayList<String>();
        String interaction = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? "player left clicks" : (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK ? "player right clicks" : "player stands");
        events.add(interaction);
        if (event.hasItem()) {
            item = new dItem(event.getItem());
            context.put("item", item);
            events.add(interaction + " with item");
            events.add(interaction + " with " + item.identify());
            if (!item.identify().equals(item.identify().split(":")[0])) {
                events.add(interaction + " with " + item.identify().split(":")[0]);
            }
        }
        if (event.hasBlock()) {
            Block block = event.getClickedBlock();
            context.put("location", new dLocation(block.getLocation()));
            interaction = interaction + " on " + block.getType().name();
            events.add(interaction);
            if (event.hasItem()) {
                events.add(interaction + " with item");
                events.add(interaction + " with " + item.identify());
                if (!item.identify().equals(item.identify().split(":")[0])) {
                    events.add(interaction + " with " + item.identify().split(":")[0]);
                }
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteractEntity(PlayerInteractEntityEvent event) {
        String determination;
        Entity entity = event.getRightClicked();
        dItem item = new dItem(event.getPlayer().getItemInHand());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getRightClicked().getLocation()));
        if (entity instanceof Player) {
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
        } else {
            context.put("entity", new dEntity(entity));
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("player right clicks entity");
        events.add("player right clicks " + entity.getType().name());
        events.add("player right clicks entity with " + item.identify());
        events.add("player right clicks " + entity.getType().name() + " with " + item.identify());
        if (!item.identify().equals(item.identify().split(":")[0])) {
            events.add("player right clicks entity with " + item.identify().split(":")[0]);
            events.add("player right clicks " + entity.getType().name() + " with " + item.identify().split(":")[0]);
        }
        if (entity instanceof ItemFrame) {
            dItem itemFrame = new dItem(((ItemFrame)entity).getItem());
            context.put("itemframe", itemFrame);
            events.add("player right clicks " + entity.getType().name() + " " + itemFrame.identify());
            if (!itemFrame.identify().equals(itemFrame.identify().split(":")[0])) {
                events.add("player right clicks " + entity.getType().name() + " " + itemFrame.identify().split(":")[0]);
            }
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerItemConsume(PlayerItemConsumeEvent event) {
        String determination;
        dItem item = new dItem(event.getItem());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("item", item);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player consumes " + item.identify());
        if (!item.identify().equals(item.identify().split(":")[0])) {
            events.add("player consumes " + item.identify().split(":")[0]);
        }
        if ((determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void joinEvent(PlayerJoinEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", new Element(event.getJoinMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player joins", "player join"), null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setJoinMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void levelChangeEvent(PlayerLevelChangeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("level", new Element(event.getNewLevel()));
        WorldScriptHelper.doEvents(Arrays.asList("player levels up", "player levels up to " + event.getNewLevel(), "player levels up from " + event.getOldLevel()), null, event.getPlayer(), context);
    }

    @EventHandler
    public void loginEvent(PlayerLoginEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("hostname", new Element(event.getHostname()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player logs in"), null, event.getPlayer(), context).toUpperCase();
        if (determination.toUpperCase().startsWith("KICKED")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void playerMoveEvent(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = dLocation.getSaved(event.getPlayer().getLocation());
        if (name != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("notable", new Element(name));
            String determination = WorldScriptHelper.doEvents(Arrays.asList("player walks over notable", "player walks over " + name, "walked over notable", "walked over " + name), null, event.getPlayer(), context);
            if (determination.toUpperCase().startsWith("CANCELLED") || determination.toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void quitEvent(PlayerQuitEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", new Element(event.getQuitMessage()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("player quits", "player quit"), null, event.getPlayer(), context).toUpperCase();
        if (determination.toUpperCase().startsWith("MESSAGE")) {
            event.setQuitMessage(aH.getStringFrom(determination));
        }
    }

    @EventHandler
    public void respawnEvent(PlayerRespawnEvent event) {
        dLocation location;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("location", new dLocation(event.getRespawnLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player respawns");
        if (event.isBedSpawn()) {
            events.add("player respawns at bed");
        } else {
            events.add("player respawns elsewhere");
        }
        String determination = WorldScriptHelper.doEvents(events, null, event.getPlayer(), context);
        if (determination.toUpperCase().startsWith("LOCATION") && (location = dLocation.valueOf(aH.getStringFrom(determination))) != null) {
            event.setRespawnLocation((Location)location);
        }
    }

    @EventHandler
    public void serverCommandEvent(ServerCommandEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        List<String> args = Arrays.asList(aH.buildArgs(TagManager.tag(null, null, event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : "")));
        dList args_list = new dList(args);
        String command = event.getCommand().split(" ")[0].replace("/", "").toUpperCase();
        context.put("args", args_list);
        context.put("command", new Element(command));
        context.put("raw_args", new Element(event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("server", Element.TRUE);
        WorldScriptHelper.doEvents(Arrays.asList("command", command + " command"), null, null, context);
    }

    @EventHandler
    public void vehicleDamage(VehicleDamageEvent event) {
        Entity entity = event.getAttacker();
        if (entity == null) {
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        Vehicle vehicle = event.getVehicle();
        String entityType = entity.getType().name();
        String vehicleType = vehicle.getType().name();
        Player player = null;
        context.put("damage", new Element(event.getDamage()));
        context.put("vehicle", new dEntity((Entity)vehicle));
        if (entity instanceof Player) {
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            player = (Player)entity;
        } else {
            context.put("entity", new dEntity(entity));
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity damages vehicle", entityType + " damages vehicle", "entity damages " + vehicleType, entityType + " damages " + vehicleType), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (aH.matchesValueArg("DAMAGE", determination, aH.ArgumentType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void vehicleDestroy(VehicleDestroyEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getAttacker();
        Vehicle vehicle = event.getVehicle();
        String entityType = entity.getType().name();
        String vehicleType = vehicle.getType().name();
        Player player = null;
        context.put("vehicle", new dEntity((Entity)vehicle));
        if (entity instanceof Player) {
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            player = (Player)entity;
        } else {
            context.put("entity", new dEntity(entity));
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity destroys vehicle", entityType + " destroys vehicle", "entity destroys " + vehicleType, entityType + " destroys " + vehicleType), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleEnter(VehicleEnterEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Entity entity = event.getEntered();
        Vehicle vehicle = event.getVehicle();
        String entityType = entity.getType().name();
        String vehicleType = vehicle.getType().name();
        Player player = null;
        context.put("vehicle", new dEntity((Entity)vehicle));
        if (entity instanceof Player) {
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            player = (Player)entity;
        } else {
            context.put("entity", new dEntity(entity));
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity enters vehicle", entityType + " enters vehicle", "entity enters " + vehicleType, entityType + " enters " + vehicleType), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleExit(VehicleExitEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LivingEntity entity = event.getExited();
        Vehicle vehicle = event.getVehicle();
        String entityType = entity.getType().name();
        String vehicleType = vehicle.getType().name();
        Player player = null;
        context.put("vehicle", new dEntity((Entity)vehicle));
        if (entity instanceof Player) {
            context.put("entity", new dPlayer((OfflinePlayer)((Player)entity)));
            player = (Player)entity;
        } else {
            context.put("entity", new dEntity((Entity)entity));
        }
        String determination = WorldScriptHelper.doEvents(Arrays.asList("entity exits vehicle", entityType + " exits vehicle", "entity exits " + vehicleType, entityType + " exits " + vehicleType), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void lightningStrike(LightningStrikeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String world = event.getWorld().getName();
        context.put("world", new dWorld(event.getWorld()));
        context.put("location", new dLocation(event.getLightning().getLocation()));
        String determination = WorldScriptHelper.doEvents(Arrays.asList("lightning strikes", "lightning strikes in " + world), null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void weatherChange(WeatherChangeEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String world = event.getWorld().getName();
        context.put("world", new dWorld(event.getWorld()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("weather changes");
        events.add("weather changes in " + world);
        if (event.toWeatherState()) {
            context.put("weather", new Element("rain"));
            events.add("weather rains");
            events.add("weather rains in " + world);
        } else {
            context.put("weather", new Element("clear"));
            events.add("weather clears");
            events.add("weather clears in " + world);
        }
        String determination = WorldScriptHelper.doEvents(events, null, null, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

