/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class ModifyBlockCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Material material = null;
        int data = 0;
        dLocation location = null;
        int radius = 0;
        int height = 0;
        int depth = 0;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to: " + location);
                continue;
            }
            if (aH.matchesValueArg("MATERIAL, M", arg, aH.ArgumentType.Custom)) {
                String value = aH.getStringFrom(arg).toUpperCase();
                if (value.split(":", 2).length > 1) {
                    data = aH.getIntegerFrom(value.split(":", 2)[1]);
                }
                if ((material = aH.matchesInteger(value = value.split(":", 2)[0]) ? Material.getMaterial((int)aH.getIntegerFrom(value)) : Material.getMaterial((String)value)) != null) {
                    dB.echoDebug("...material set to " + material);
                    continue;
                }
                dB.echoDebug("...material not valid.");
                continue;
            }
            if (aH.matchesValueArg("RADIUS, R", arg, aH.ArgumentType.Integer)) {
                radius = aH.getIntegerFrom(arg);
                dB.echoDebug("...radius set to " + radius);
                continue;
            }
            if (aH.matchesValueArg("HEIGHT, H", arg, aH.ArgumentType.Integer)) {
                height = aH.getIntegerFrom(arg);
                dB.echoDebug("...height set to " + height);
                continue;
            }
            if (aH.matchesValueArg("DEPTH, D", arg, aH.ArgumentType.Integer)) {
                depth = aH.getIntegerFrom(arg);
                dB.echoDebug("...depth set to " + depth);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("material", material);
        scriptEntry.addObject("data", data);
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("radius", radius);
        scriptEntry.addObject("height", height);
        scriptEntry.addObject("depth", depth);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int y;
        Block currentBlock;
        int z;
        int x;
        Material material = (Material)scriptEntry.getObject("material");
        int data = (Integer)scriptEntry.getObject("data");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        int radius = (Integer)scriptEntry.getObject("radius");
        int height = (Integer)scriptEntry.getObject("height");
        int depth = (Integer)scriptEntry.getObject("depth");
        if (location == null || material == null) {
            dB.echoDebug("...can not exectue");
            return;
        }
        World world = scriptEntry.getPlayer().getPlayerEntity().getWorld();
        Block startBlock = location.getBlock();
        startBlock.setType(material);
        startBlock.setData((byte)data);
        if (radius != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY(), startBlock.getZ() + z - radius);
                    if (currentBlock.getType() == material) continue;
                    currentBlock.setType(material);
                    currentBlock.setData((byte)data);
                }
            }
        }
        if (height != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < height + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() + y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material) continue;
                        currentBlock.setType(material);
                        currentBlock.setData((byte)data);
                    }
                }
            }
        }
        if (depth != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < depth + 1; ++y) {
                        currentBlock = world.getBlockAt(startBlock.getX() + x - radius, startBlock.getY() - y, startBlock.getZ() + z - radius);
                        if (currentBlock.getType() == material) continue;
                        currentBlock.setType(material);
                        currentBlock.setData((byte)data);
                    }
                }
            }
        }
    }
}

