/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import com.google.common.primitives.Ints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class Duration
implements dObject {
    static final Pattern match = Pattern.compile("(\\d+.\\d+|.\\d+|\\d+)(t|m|s|h|d|)(?:(?:-\\d+.\\d+|.\\d+|\\d+)(?:t|m|s|h|d|))?", 2);
    public static final Duration ZERO = new Duration(0);
    private double seconds;
    private String prefix = "Duration";

    @ObjectFetcher(value="d")
    public static Duration valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("-") > 0 && Duration.matches(string.split("-", 2)[0]) && Duration.matches(string.split("-", 2)[1])) {
            String[] split = string.split("-", 2);
            Duration low = Duration.valueOf(split[0]);
            Duration high = Duration.valueOf(split[1]);
            if (low != null && high != null && low.getSecondsAsInt() < high.getSecondsAsInt()) {
                int seconds = Utilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1 + low.getSecondsAsInt());
                dB.echoDebug("Getting random duration between " + low.identify() + " and " + high.identify() + "... " + seconds + "s");
                return new Duration(seconds);
            }
            return null;
        }
        Matcher m = match.matcher(string);
        if (m.matches()) {
            if (m.group().toUpperCase().endsWith("T")) {
                return new Duration(Double.valueOf(m.group(1)) * 0.05);
            }
            if (m.group().toUpperCase().endsWith("D")) {
                return new Duration(Double.valueOf(m.group(1)) * 86400.0);
            }
            if (m.group().toUpperCase().endsWith("M")) {
                return new Duration(Double.valueOf(m.group(1)) * 60.0);
            }
            if (m.group().toUpperCase().endsWith("H")) {
                return new Duration(Double.valueOf(m.group(1)) * 3600.0);
            }
            return new Duration(Double.valueOf(m.group(1)));
        }
        return null;
    }

    public static boolean matches(String string) {
        Matcher m = match.matcher(string);
        return m.matches();
    }

    public Duration(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(long ticks) {
        this.seconds = ticks / 20L;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return Ints.checkedCast((long)((long)(this.seconds * 20.0)));
    }

    public long getMillis() {
        return (long)(this.seconds * 1000.0);
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return ChatColor.DARK_GRAY + this.prefix + "='" + ChatColor.YELLOW + this.identify() + ChatColor.DARK_GRAY + "'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getType() {
        return "duration";
    }

    public String identify() {
        double seconds = this.getTicks() / 20L;
        double days = seconds / 86400.0;
        double hours = seconds / 3600.0;
        double minutes = seconds / 60.0;
        if (days >= 1.0) {
            return days + "d";
        }
        if (hours >= 2.0) {
            return hours + "h";
        }
        if (minutes >= 2.0) {
            return minutes + "m";
        }
        return seconds + "s";
    }

    public String toString() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("in_seconds")) {
            return new Element(String.valueOf(this.seconds)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_hours")) {
            return new Element(String.valueOf(this.seconds / 1800.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_minutes")) {
            return new Element(String.valueOf(this.seconds / 60.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_ticks")) {
            return new Element(String.valueOf(this.getTicksAsInt())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("value")) {
            if (this.seconds % 43200.0 == 0.0) {
                return new Element(this.seconds / 86400.0 + "d").getAttribute(attribute.fulfill(1));
            }
            if (this.seconds % 1800.0 == 0.0) {
                return new Element(this.seconds / 3600.0 + "h").getAttribute(attribute.fulfill(1));
            }
            if (this.seconds % 30.0 == 0.0) {
                return new Element(this.seconds / 60.0 + "m").getAttribute(attribute.fulfill(1));
            }
            return new Element(this.seconds + "s").getAttribute(attribute.fulfill(1));
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }
}

