/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.MetadataValue;

public class dPlayer
implements dObject {
    static Map<String, dPlayer> players = new HashMap<String, dPlayer>();
    String player_name = null;
    private String prefix = "Player";

    public static dPlayer mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (players.containsKey(player.getName())) {
            return players.get(player.getName());
        }
        return new dPlayer(player);
    }

    @ObjectFetcher(value="p")
    public static dPlayer valueOf(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("p@", "");
        OfflinePlayer returnable = null;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(string)) continue;
            returnable = player;
            break;
        }
        if (returnable != null) {
            if (players.containsKey(returnable.getName())) {
                return players.get(returnable.getName());
            }
            return new dPlayer(returnable);
        }
        dB.echoError("Invalid Player! '" + string + "' could not be found. Has the player logged off?");
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("p@", "");
        OfflinePlayer returnable = null;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            returnable = player;
            break;
        }
        return returnable != null;
    }

    public dPlayer(OfflinePlayer player) {
        if (player == null) {
            return;
        }
        this.player_name = player.getName();
        players.put(this.player_name, this);
    }

    public boolean isValid() {
        if (this.player_name == null) {
            return false;
        }
        return this.getPlayerEntity() != null || this.getOfflinePlayer() != null;
    }

    public Player getPlayerEntity() {
        if (this.player_name == null) {
            return null;
        }
        return Bukkit.getPlayer((String)this.player_name);
    }

    public OfflinePlayer getOfflinePlayer() {
        if (this.player_name == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((String)this.player_name);
    }

    public dEntity getDenizenEntity() {
        return new dEntity((Entity)this.getPlayerEntity());
    }

    public dNPC getSelectedNPC() {
        if (this.getPlayerEntity().hasMetadata("selected")) {
            return dNPC.valueOf(((MetadataValue)this.getPlayerEntity().getMetadata("selected").get(0)).asString());
        }
        return null;
    }

    public String getName() {
        return this.player_name;
    }

    public dLocation getLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getLocation());
        }
        return null;
    }

    public dLocation getEyeLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return null;
    }

    public boolean isOnline() {
        if (this.player_name == null) {
            return false;
        }
        return Bukkit.getPlayer((String)this.player_name) != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dPlayer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return true;
    }

    public String getType() {
        return "Player";
    }

    public String identify() {
        return "p@" + this.player_name;
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (this.player_name == null) {
            return "null";
        }
        if (attribute.startsWith("entity")) {
            return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_played_before")) {
            return new Element(String.valueOf(this.getOfflinePlayer().hasPlayedBefore())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_op")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isOp())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("first_played")) {
            return new Element(String.valueOf(this.getOfflinePlayer().getFirstPlayed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_played")) {
            return new Element(String.valueOf(this.getOfflinePlayer().getLastPlayed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_banned")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isBanned())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_whitelisted")) {
            return new Element(String.valueOf(this.getOfflinePlayer().isWhitelisted())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name") && !this.isOnline()) {
            return new Element(this.player_name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_online")) {
            return new Element(String.valueOf(this.isOnline())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ip")) {
            return this.getPlayerEntity().getAddress().getHostName();
        }
        if (attribute.startsWith("list")) {
            ArrayList<String> players = new ArrayList<String>();
            if (attribute.startsWith("list.online")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("list.offline")) {
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    if (Bukkit.getOnlinePlayers().toString().contains(player.getName())) continue;
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                players.add(player.getName());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history_list")) {
            return new dList(PlayerTags.playerChatHistory.get(this.player_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history")) {
            int x = 1;
            if (attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                x = attribute.getIntContext(1);
            }
            return new Element(PlayerTags.playerChatHistory.get(this.player_name).get(x - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("bed_spawn")) {
            return new dLocation(this.getOfflinePlayer().getBedSpawnLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("money")) {
            if (Depends.economy != null) {
                if (attribute.startsWith("money.currency_singular")) {
                    return new Element(Depends.economy.currencyNameSingular()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("money.currency")) {
                    return new Element(Depends.economy.currencyNamePlural()).getAttribute(attribute.fulfill(2));
                }
                return new Element(String.valueOf(Depends.economy.getBalance(this.player_name))).getAttribute(attribute.fulfill(1));
            }
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            return null;
        }
        if (!this.isOnline()) {
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("xp.total")) {
            return new Element(String.valueOf(this.getPlayerEntity().getTotalExperience())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.level")) {
            return new Element(this.getPlayerEntity().getLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp")) {
            return new Element(String.valueOf(this.getPlayerEntity().getExp() * 100.0f)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("equipment.boots") && this.getPlayerEntity().getInventory().getBoots() != null) {
            return new dItem(this.getPlayerEntity().getInventory().getBoots()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.chestplate") && this.getPlayerEntity().getInventory().getChestplate() != null) {
            return new dItem(this.getPlayerEntity().getInventory().getChestplate()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.helmet") && this.getPlayerEntity().getInventory().getHelmet() != null) {
            return new dItem(this.getPlayerEntity().getInventory().getHelmet()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment.leggings") && this.getPlayerEntity().getInventory().getLeggings() != null) {
            return new dItem(this.getPlayerEntity().getInventory().getLeggings()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("equipment")) {
            return new dInventory(InventoryType.CRAFTING).add(this.getPlayerEntity().getInventory().getArmorContents()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return new dInventory((Inventory)this.getPlayerEntity().getInventory()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_in_hand")) {
            return new dItem(this.getPlayerEntity().getItemInHand()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name.display")) {
            return new Element(this.getPlayerEntity().getDisplayName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name.list")) {
            return new Element(this.getPlayerEntity().getPlayerListName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.player_name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eyes")) {
            return new dLocation(this.getEyeLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("compass_target")) {
            return new dLocation(this.getPlayerEntity().getCompassTarget()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("food_level.formatted")) {
            double maxHunger = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHunger = attribute.getIntContext(2);
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.1) {
                return new Element("starving").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.4) {
                return new Element("famished").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.75) {
                return new Element("parched").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 1.0) {
                return new Element("hungry").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("food_level")) {
            return new Element(String.valueOf(this.getPlayerEntity().getFoodLevel())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("permission") || attribute.startsWith("has_permission")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return null;
            }
            String permission = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(String.valueOf(Depends.permissions.has((World)null, this.player_name, permission))).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(String.valueOf(Depends.permissions.has(attribute.getContext(2), this.player_name, permission))).getAttribute(attribute.fulfill(2));
            }
            return new Element(String.valueOf(Depends.permissions.has(this.getPlayerEntity(), permission))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return "null";
            }
            String flag_name = attribute.getContext(1);
            attribute.fulfill(1);
            if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("size") && !FlagManager.playerHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(1));
            }
            if (FlagManager.playerHasFlag(this, flag_name)) {
                return new dList(DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(this.getName(), flag_name)).getAttribute(attribute);
            }
            return "null";
        }
        if (attribute.startsWith("group") || attribute.startsWith("in_group")) {
            if (Depends.permissions == null) {
                dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                return "null";
            }
            String group = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(String.valueOf(Depends.permissions.playerInGroup((World)null, this.player_name, group))).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(String.valueOf(Depends.permissions.playerInGroup(attribute.getContext(2), this.player_name, group))).getAttribute(attribute.fulfill(2));
            }
            return new Element(String.valueOf(Depends.permissions.playerInGroup(this.getPlayerEntity(), group))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flying")) {
            return new Element(String.valueOf(this.getPlayerEntity().isFlying())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sneaking")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSneaking())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_blocking")) {
            return new Element(String.valueOf(this.getPlayerEntity().isBlocking())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sleeping")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSleeping())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sprinting")) {
            return new Element(String.valueOf(this.getPlayerEntity().isSprinting())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode.id")) {
            return new Element(String.valueOf(this.getPlayerEntity().getGameMode().getValue())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode")) {
            return new Element(String.valueOf(this.getPlayerEntity().getGameMode().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_on_cursor")) {
            return new dItem(this.getPlayerEntity().getItemOnCursor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("selected_npc")) {
            if (this.getPlayerEntity().hasMetadata("selected")) {
                return dNPC.valueOf(((MetadataValue)this.getPlayerEntity().getMetadata("selected").get(0)).asString()).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("allowed_flight")) {
            return new Element(String.valueOf(this.getPlayerEntity().getAllowFlight())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("host_name")) {
            return new Element(String.valueOf(this.getPlayerEntity().getAddress().getHostName())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_asleep")) {
            return new Duration(this.getPlayerEntity().getSleepTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("player_time")) {
            return new Element(String.valueOf(this.getPlayerEntity().getPlayerTime())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("player_time_offset")) {
            return new Element(String.valueOf(this.getPlayerEntity().getPlayerTimeOffset())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute.fulfill(0));
    }
}

