/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class RequirementChecker {
    private Denizen plugin;

    public RequirementChecker(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean check(RequirementsContext context) {
        if (context.mode.getMode() == RequirementsMode.Mode.NONE || context.list.isEmpty()) {
            return true;
        }
        dB.echoDebug(ChatColor.YELLOW + "CHECK! Now checking '%s'", context.container.getName());
        dB.echoDebug("Requirement mode: '%s'", context.mode.getMode().toString());
        int index = -1;
        int numberChecked = 0;
        int[] numberMet = new int[context.mode.modeInt.length];
        for (String reqEntry : context.list) {
            boolean reqMet;
            block21: {
                List<String> argumentList;
                String reqString;
                boolean negativeRequirement = false;
                reqMet = false;
                if (reqEntry.startsWith("-")) {
                    negativeRequirement = true;
                    reqEntry = reqEntry.substring(1);
                }
                if ((reqString = (argumentList = TagManager.fillArguments(aH.buildArgs(reqEntry), context.player, context.npc)).get(0).toUpperCase()).equals("VALUEOF")) {
                    String arg = argumentList.get(1);
                    String debug = "Checking '" + (negativeRequirement ? "-" : "") + "VALUEOF' " + arg + "... requirement ";
                    if (arg.equalsIgnoreCase("true") != negativeRequirement) {
                        debug = debug + "met!";
                        reqMet = true;
                    } else {
                        debug = debug + "not met!";
                    }
                    dB.echoApproval(debug);
                } else if (this.plugin.getRequirementRegistry().list().containsKey(reqString)) {
                    AbstractRequirement requirement = this.plugin.getRequirementRegistry().get(reqString);
                    argumentList.remove(0);
                    try {
                        int numArguments = argumentList.isEmpty() ? 0 : argumentList.size();
                        int neededArguments = requirement.requirementOptions.REQUIRED_ARGS;
                        if (numArguments == 0 && neededArguments > 0 || numArguments < neededArguments) {
                            throw new RequirementCheckException("Not enough arguments (" + numArguments + " / " + neededArguments + ")");
                        }
                        reqMet = requirement.check(context, argumentList) != negativeRequirement;
                        dB.echoApproval("Checking Requirement '" + requirement.getName() + "'" + " ...requirement " + (reqMet ? "" : "not") + " met!");
                    }
                    catch (Throwable e) {
                        if (e instanceof RequirementCheckException) {
                            String msg = e.getMessage().isEmpty() || e == null ? "No Error message defined!" : e.getMessage();
                            dB.echoError("Woah! Invalid arguments were specified: " + msg);
                            dB.echoError("Usage: " + requirement.getUsageHint());
                            break block21;
                        }
                        dB.echoError("Woah! An exception has been called " + (requirement != null ? "for Requirement '" + requirement.getName() + "'" : "") + "!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block21;
                        }
                        e.printStackTrace();
                    }
                } else {
                    dB.echoError("Requirement '" + reqEntry.split(" ")[0] + "' not found! Check that the requirement is installed!");
                }
            }
            if (index < 0 || context.mode.modeInt[index] == numberChecked) {
                numberChecked = 0;
                numberMet[++index] = 0;
            }
            ++numberChecked;
            if (!reqMet) continue;
            int n = index;
            numberMet[n] = numberMet[n] + 1;
        }
        switch (context.mode.getMode()) {
            case ALL: {
                return numberMet[0] == context.list.size();
            }
            case ANY_NUM: {
                return numberMet[0] == context.mode.modeInt[0];
            }
            case FIRST_NUM_AND_ANY_NUM: {
                for (int n = 0; n < context.mode.modeInt.length; ++n) {
                    if (context.mode.modeInt[n] == numberMet[n]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

