/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dScript;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ZapCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("step") && arg.hasPrefix() && arg.getPrefix().matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.getPrefix().asType(dScript.class));
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("step")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (scriptEntry.hasObject("step")) continue;
            scriptEntry.addObject("step", arg.asElement());
        }
        if (!scriptEntry.hasObject("script")) {
            scriptEntry.addObject("script", scriptEntry.getScript());
        }
        if (!scriptEntry.hasPlayer() || !scriptEntry.getPlayer().isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        final dScript script = (dScript)scriptEntry.getObject("script");
        String step = scriptEntry.getElement("step").asString();
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(this.getName(), scriptEntry.getPlayer().debug() + script.debug() + scriptEntry.getElement("step").debug() + (duration != null ? duration.debug() : ""));
        String currentStep = InteractScriptHelper.getCurrentStep(scriptEntry.getPlayer(), script.getName());
        if (step == null) {
            step = aH.matchesInteger(currentStep) ? String.valueOf(aH.getIntegerFrom(currentStep) + 1) : "1";
        }
        if (durations.containsKey(scriptEntry.getPlayer().getName() + "," + script.getName())) {
            try {
                this.denizen.getServer().getScheduler().cancelTask(durations.get(scriptEntry.getPlayer().getName() + "," + script.getName()).intValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (duration != null && duration.getSeconds() > 0.0) {
            scriptEntry.addObject("step", currentStep);
            scriptEntry.addObject("duration", Duration.ZERO);
            long delay = (long)(duration.getSeconds() * 20.0);
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "RESET ZAP for '" + script + "'");
            durations.put(scriptEntry.getPlayer().getName() + "," + script.getName(), this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, new Runnable(){

                public void run() {
                    block2: {
                        dB.log(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "RESET ZAP for '" + script.getName() + "'");
                        try {
                            durations.remove(scriptEntry.getPlayer().getName() + "," + script.getName().toUpperCase());
                            ZapCommand.this.execute(scriptEntry);
                        }
                        catch (CommandExecutionException e) {
                            dB.echoError("Could not run delayed task!");
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, delay));
        }
        this.denizen.getSaves().set("Players." + scriptEntry.getPlayer().getName() + ".Scripts." + script.getName().toUpperCase() + "." + "Current Step", (Object)step);
    }
}

