/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequirementsMode {
    private static final Pattern intsOnly = Pattern.compile("(\\d+)");
    protected final Mode mode;
    protected int[] modeInt;

    public Mode getMode() {
        return this.mode;
    }

    public RequirementsMode(String arg) {
        arg = arg.trim().toUpperCase();
        if (arg.equals("NONE")) {
            this.mode = Mode.NONE;
        } else if (arg.equals("ALL")) {
            this.mode = Mode.ALL;
        } else {
            boolean first = arg.contains("FIRST");
            boolean any = arg.contains("ANY");
            Matcher found = intsOnly.matcher(arg);
            if (!any) {
                this.mode = Mode.NONE;
            } else if (!first) {
                this.mode = Mode.ANY_NUM;
                this.modeInt = found.matches() ? new int[]{Integer.valueOf(found.group(1))} : new int[]{1};
            } else {
                this.mode = Mode.FIRST_NUM_AND_ANY_NUM;
                int count = found.groupCount();
                this.modeInt = new int[2];
                if (count >= 2) {
                    this.modeInt[0] = Integer.valueOf(found.group(1));
                    this.modeInt[1] = Integer.valueOf(found.group(2));
                } else if (count == 1) {
                    int index = 1;
                    if (arg.startsWith("FIRST AND")) {
                        this.modeInt[0] = 1;
                    } else {
                        this.modeInt[0] = Integer.valueOf(found.group(index));
                        ++index;
                    }
                    this.modeInt[1] = arg.endsWith("ANY") ? 1 : Integer.valueOf(found.group(index));
                }
            }
        }
    }

    public RequirementsMode(Mode mode) {
        this(mode, 1);
    }

    public RequirementsMode(Mode mode, int num) {
        this.mode = mode;
        this.modeInt = new int[]{num};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ALL,
        NONE,
        ANY_NUM,
        FIRST_NUM_AND_ANY_NUM;

    }
}

