/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class YamlCommand
extends AbstractCommand
implements Listener {
    Map<String, YamlConfiguration> yamls = new HashMap<String, YamlConfiguration>();

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    private YamlConfiguration getYaml(String id) {
        if (id == null) {
            return null;
        }
        return this.yamls.get(id.toUpperCase());
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        String key = null;
        String value = null;
        String filename = null;
        String id = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("LOAD, CREATE, SAVE", arg, aH.ArgumentType.Custom)) {
                action = Action.valueOf(arg.split(":")[0].toUpperCase());
                filename = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("READ, WRITE", arg, aH.ArgumentType.Custom)) {
                action = Action.valueOf(arg.split(":")[0].toUpperCase());
                key = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("VALUE", arg, aH.ArgumentType.Custom)) {
                value = aH.getStringFrom(arg);
                continue;
            }
            id = aH.getStringFrom(arg);
        }
        if (id == null) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (action == null) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if ((action == Action.READ || action == Action.WRITE) && key == null) {
            throw new InvalidArgumentsException("Must specify a key!");
        }
        if ((action == Action.CREATE || action == Action.LOAD || action == Action.SAVE) && filename == null) {
            throw new InvalidArgumentsException("Must specify a filename!");
        }
        scriptEntry.addObject("filename", filename).addObject("action", (Object)action).addObject("key", key).addObject("value", value).addObject("id", id);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String filename = (String)scriptEntry.getObject("filename");
        String key = (String)scriptEntry.getObject("key");
        String value = (String)scriptEntry.getObject("value");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String id = (String)scriptEntry.getObject("id");
        switch (action) {
            case LOAD: {
                File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename);
                if (file == null) {
                    throw new CommandExecutionException("File cannot be found!");
                }
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                if (yamlConfiguration == null) break;
                this.yamls.put(id.toUpperCase(), yamlConfiguration);
                break;
            }
            case SAVE: {
                if (!this.yamls.containsKey(id.toUpperCase())) break;
                try {
                    this.yamls.get(id.toUpperCase()).save(new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case WRITE: {
                if (!this.yamls.containsKey(id.toUpperCase())) break;
                this.yamls.get(id.toUpperCase()).set(key, (Object)value);
                break;
            }
            case CREATE: {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(DenizenAPI.getCurrentInstance().getDataFolder(), filename));
                if (yamlConfiguration == null) break;
                this.yamls.put(id.toUpperCase(), yamlConfiguration);
            }
        }
    }

    @EventHandler
    public void yaml(ReplaceableTagEvent event) {
        if (!event.matches("yaml")) {
            return;
        }
        if (!event.hasNameContext() || !event.hasTypeContext()) {
            dB.echoError("YAML tag '" + event.raw_tag + "' is missing required context. Tag replacement aborted.");
            return;
        }
        String id = event.getNameContext();
        String path = event.getTypeContext();
        if (!this.yamls.containsKey(id.toUpperCase())) {
            dB.echoError("YAML tag '" + event.raw_tag + "' has specified an invalid ID, or the specified id has already" + "been closed. Tag replacement aborted.");
            return;
        }
        Attribute attribute = new Attribute(event.raw_tag, event.getScriptEntry());
        attribute.fulfill(1);
        if (attribute.startsWith("contains")) {
            event.setReplaced(new Element(String.valueOf(this.getYaml(id).contains(path))).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("read")) {
            String value = this.getYaml(id).getString(path);
            if (value == null) {
                dB.echoDebug("YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced("null");
                return;
            }
            event.setReplaced(new Element(value).getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("list_keys")) {
            ConfigurationSection section = this.getYaml(id).getConfigurationSection(path);
            if (section == null) {
                dB.echoDebug("YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced("null");
                return;
            }
            Set keys = section.getKeys(false);
            if (keys == null) {
                dB.echoDebug("YAML tag '" + event.raw_tag + "' has returned null.");
                event.setReplaced("null");
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(keys);
            event.setReplaced(new dList((List<String>)list).getAttribute(attribute.fulfill(1)));
        }
        dB.echoError("YAML tag '" + event.raw_tag + "' has an invalid attribute. Tag replacement aborted.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        LOAD,
        CREATE,
        READ,
        WRITE,
        SAVE;

    }
}

