/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dList;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;

public class HurtCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("amount") && (arg.matchesPrimitive(aH.PrimitiveType.Double) || arg.matchesPrimitive(aH.PrimitiveType.Integer))) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("entities") || !arg.matchesArgumentList(dEntity.class)) continue;
            scriptEntry.addObject("entities", ((dList)arg.asType(dList.class)).filter(dEntity.class));
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", 1.0);
        }
        if (!scriptEntry.hasObject("entities")) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            if (scriptEntry.getPlayer() != null) {
                entities.add(scriptEntry.getPlayer().getDenizenEntity());
            } else if (scriptEntry.getNPC() != null) {
                entities.add(scriptEntry.getNPC().getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found.");
            }
            scriptEntry.addObject("entities", entities);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Double amount = ((Element)scriptEntry.getObject("amount")).asDouble();
        List entities = (List)scriptEntry.getObject("entities");
        for (dEntity entity : entities) {
            entity.getLivingEntity().damage(amount.doubleValue());
        }
    }
}

