/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EngraveCommand
extends AbstractCommand
implements Listener {
    Map<String, Long> notifyCooldown = new HashMap<String, Long>();
    Map<Integer, Long> despawnDelay = new HashMap<Integer, Long>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.ADD;
        String target = scriptEntry.getPlayer().getName();
        ItemStack item = scriptEntry.getPlayer().getPlayerEntity().getItemInHand() != null ? scriptEntry.getPlayer().getPlayerEntity().getItemInHand() : null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, REMOVE, REMOVEALL", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesItem(arg)) {
                item = aH.getItemFrom(arg).getItemStack();
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (item == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "ITEM");
        }
        if (target == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        scriptEntry.addObject("action", (Object)action).addObject("target", target).addObject("item", item);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String target = String.valueOf(scriptEntry.getObject("target"));
        ItemStack item = (ItemStack)scriptEntry.getObject("item");
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Target", target) + aH.debugObj("Item", item.getType().toString()));
        switch (action) {
            case ADD: {
                dB.echoDebug("Engraving '" + item.getType() + "' with an inscription of '" + target + "'.");
                CustomNBT.addCustomNBT(item, "owner", target);
                dB.echoDebug(CustomNBT.getCustomNBT(item, "owner"));
                return;
            }
            case REMOVE: {
                dB.echoDebug("Removing engraving on '" + item.getType() + "'.");
                CustomNBT.removeCustomNBT(item, "owner");
                return;
            }
        }
    }

    @EventHandler
    public void checkOwner(PlayerPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (CustomNBT.hasCustomNBT(item, "owner") && !CustomNBT.getCustomNBT(item, "owner").equalsIgnoreCase(event.getPlayer().getName())) {
            dB.echoDebug(CustomNBT.getCustomNBT(item, "owner"));
            if (event.getPlayer().isSneaking()) {
                if (!this.notifyCooldown.containsKey(event.getPlayer().getName())) {
                    this.notifyCooldown.put(event.getPlayer().getName(), System.currentTimeMillis() + 10000L);
                    event.getPlayer().sendMessage("That " + event.getItem().getItemStack().getType() + " does not belong to you!");
                } else if (this.notifyCooldown.get(event.getPlayer().getName()) < System.currentTimeMillis()) {
                    this.notifyCooldown.remove(event.getPlayer().getName());
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void stopDespawn(ItemDespawnEvent event) {
        ItemStack item = event.getEntity().getItemStack();
        if (CustomNBT.hasCustomNBT(item, "owner")) {
            dB.echoDebug(CustomNBT.getCustomNBT(item, "owner"));
            if (this.despawnDelay.containsKey(event.getEntity().getEntityId())) {
                if (this.despawnDelay.get(event.getEntity().getEntityId()) < System.currentTimeMillis()) {
                    event.setCancelled(true);
                } else {
                    dB.echoDebug("Removed an ENGRAVED '" + item.getType().name() + "' which belonged to '" + CustomNBT.getCustomNBT(item, "owner") + "'.");
                }
                this.despawnDelay.remove(event.getEntity().getEntityId());
            } else {
                event.setCancelled(true);
                dB.echoDebug("Stopped despawn of an ENGRAVED '" + item + "' which belonged to '" + CustomNBT.getCustomNBT(item, "owner") + "'. Will remove from world in 10 minutes.");
                this.despawnDelay.put(event.getEntity().getEntityId(), System.currentTimeMillis() + 600000L);
            }
        }
    }

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE;

    }
}

