/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.minecraft.server.v1_6_R2.Block;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R2.CraftWorld;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new ConcurrentHashMap<Location, Integer>(8, 0.9f, 1);
    SwitchState switchState;
    Location interactLocation;
    int duration = -1;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry theEntry) throws InvalidArgumentsException {
        this.interactLocation = null;
        this.duration = -1;
        this.switchState = SwitchState.TOGGLE;
        for (String arg : theEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                this.duration = Integer.valueOf(arg.split(":")[1]);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (aH.matchesValueArg("STATE", arg, aH.ArgumentType.Custom)) {
                String state = aH.getStringFrom(arg).toUpperCase();
                if (state.matches("ON|OPEN")) {
                    this.switchState = SwitchState.ON;
                } else if (state.matches("OFF|CLOSE")) {
                    this.switchState = SwitchState.OFF;
                } else if (state.matches("TOGGLE")) {
                    this.switchState = SwitchState.TOGGLE;
                }
                dB.echoDebug("...set STATE: " + this.switchState.toString());
                continue;
            }
            if (aH.matchesLocation(arg)) {
                this.interactLocation = aH.getLocationFrom(arg);
                if (this.interactLocation == null) continue;
                dB.echoDebug("...switch LOCATION now: '%s'", arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.interactLocation == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.switchBlock(this.interactLocation, this.switchState);
        if (this.duration > 0) {
            if (this.taskMap.containsKey(this.interactLocation)) {
                try {
                    this.denizen.getServer().getScheduler().cancelTask(this.taskMap.get(this.interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dB.echoDebug(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "SWITCH");
            this.taskMap.put(this.interactLocation, this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, new Runnable(){

                public void run() {
                    if (SwitchCommand.this.switchState == SwitchState.OFF && (SwitchCommand.this.interactLocation.getBlock().getData() & 8) <= 0) {
                        SwitchCommand.this.switchBlock(SwitchCommand.this.interactLocation, SwitchState.ON);
                    } else if (SwitchCommand.this.switchState == SwitchState.ON && (SwitchCommand.this.interactLocation.getBlock().getData() & 8) > 0) {
                        SwitchCommand.this.switchBlock(SwitchCommand.this.interactLocation, SwitchState.OFF);
                    } else if (SwitchCommand.this.switchState == SwitchState.TOGGLE) {
                        SwitchCommand.this.switchBlock(SwitchCommand.this.interactLocation, SwitchState.TOGGLE);
                    }
                }
            }, (long)(this.duration * 20)));
        }
    }

    public void switchBlock(Location interactLocation, SwitchState switchState) {
        World world = interactLocation.getWorld();
        boolean currentState = (interactLocation.getBlock().getData() & 8) > 0;
        String state = switchState.toString();
        if (state == "ON" && !currentState || state == "OFF" && currentState || state == "TOGGLE") {
            try {
                Block.byId[interactLocation.getBlock().getType().getId()].interact((net.minecraft.server.v1_6_R2.World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                dB.echoDebug("Switched " + interactLocation.getBlock().getType().toString() + "! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
            }
            catch (NullPointerException e) {
                dB.echoDebug("Cannot switch " + interactLocation.getBlock().getType().toString() + "!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

