/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.queues.core;

import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.Duration;
import net.aufdemrand.denizen.scripts.queues.ScriptQueue;
import net.aufdemrand.denizen.scripts.queues.core.Delayable;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TimedQueue
extends ScriptQueue
implements Delayable {
    private int task_id;
    private long ticks;
    protected boolean paused = false;
    protected long delay_ticks = 0L;

    public static TimedQueue getQueue(String id) {
        if (id == null) {
            id = String.valueOf(TimedQueue._getNextId());
        }
        TimedQueue scriptQueue = TimedQueue._queueExists(id) ? (TimedQueue)ScriptQueue._queues.get(id.toUpperCase()) : new TimedQueue(id, Duration.valueOf(Settings.ScriptQueueSpeed()));
        return scriptQueue;
    }

    public void delayFor(Duration duration) {
        this.delay_ticks = System.currentTimeMillis() + duration.getMillis();
    }

    public boolean isDelayed() {
        return this.delay_ticks > System.currentTimeMillis();
    }

    public TimedQueue(String id, Duration timing) {
        super(id);
        this.ticks = timing.getTicks();
    }

    public Duration getSpeed() {
        return new Duration(this.ticks);
    }

    public TimedQueue setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public TimedQueue setSpeed(long ticks) {
        this.ticks = ticks;
        return this;
    }

    protected void onStart() {
        this.task_id = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                TimedQueue.this.revolve();
            }
        }, 0L, this.ticks == 0L ? 1L : this.ticks);
    }

    protected void onStop() {
        Bukkit.getScheduler().cancelTask(this.task_id);
    }

    protected boolean shouldRevolve() {
        if (this.paused) {
            return false;
        }
        return !this.isDelayed();
    }
}

