/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("volume, v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("pitch, p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("sound") || !arg.matchesPrimitive(aH.PrimitiveType.String)) continue;
            try {
                scriptEntry.addObject("sound", Sound.valueOf((String)arg.asElement().asString().toUpperCase()));
            }
            catch (Exception e) {
                dB.echoError("Invalid sound!");
            }
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "SOUND");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
        if (!scriptEntry.hasObject("volume")) {
            scriptEntry.addObject("volume", new Element(1));
        }
        if (!scriptEntry.hasObject("pitch")) {
            scriptEntry.addObject("pitch", new Element(1));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Sound sound = (Sound)scriptEntry.getObject("sound");
        Float volume = Float.valueOf(((Element)scriptEntry.getObject("volume")).asFloat());
        Float pitch = Float.valueOf(((Element)scriptEntry.getObject("pitch")).asFloat());
        dB.echoApproval("Executing '" + this.getName() + "': " + "Location='" + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "', " + "Sound='" + sound.toString() + ", " + "Volume/Pitch='" + volume + "/" + pitch + "'");
        location.getWorld().playSound(location, sound, volume.floatValue(), pitch.floatValue());
    }
}

