/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.Element;
import net.aufdemrand.denizen.objects.ObjectFetcher;
import net.aufdemrand.denizen.objects.aH;
import net.aufdemrand.denizen.objects.dObject;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.Utilities;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;

public class dMaterial
implements dObject {
    static final Pattern materialPattern = Pattern.compile("(?:m@)?(\\w+):?(\\d+)?", 2);
    private Material material;
    private Byte data = 0;
    String prefix = "material";

    @ObjectFetcher(value="m")
    public static dMaterial valueOf(String string) {
        if (string.toLowerCase().matches("random") || string.toLowerCase().matches("m@random")) {
            return new dMaterial(Material.values()[Utilities.getRandom().nextInt(Material.values().length)]);
        }
        Matcher m = materialPattern.matcher(string);
        if (m.matches()) {
            int data = -1;
            if (m.group(2) != null) {
                data = aH.getIntegerFrom(m.group(2));
            }
            if (aH.matchesInteger(m.group(1))) {
                return new dMaterial(aH.getIntegerFrom(m.group(1)), data);
            }
            for (Material material : Material.values()) {
                if (!material.name().equalsIgnoreCase(m.group(1))) continue;
                return new dMaterial(material, data);
            }
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.toUpperCase().matches("RANDOM")) {
            return true;
        }
        Matcher m = materialPattern.matcher(arg);
        return m.matches();
    }

    public dMaterial(Material material) {
        this.material = material;
    }

    public dMaterial(Material material, int data) {
        this.material = material;
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
    }

    public dMaterial(int id) {
        this.material = Material.getMaterial((int)id);
    }

    public dMaterial(int id, int data) {
        this.material = Material.getMaterial((int)id);
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean specifiedData() {
        return this.data != null;
    }

    public boolean matchesMaterialData(MaterialData data) {
        if (this.specifiedData()) {
            return this.material == data.getItemType() && data.equals((Object)data.getData());
        }
        return this.material == data.getItemType();
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data != null ? this.data : (byte)0);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getType() {
        return "Material";
    }

    public String identify() {
        return "m@" + this.material.name();
    }

    public String toString() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public String getAttribute(Attribute attribute) {
        return new Element(this.identify()).getAttribute(attribute);
    }
}

